import { _ as _export_sfc, q as __nuxt_component_0 } from '../server.mjs';
import { defineComponent, useSSRContext, mergeProps, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString, createTextVNode } from 'vue';
import { ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';
import '../../nitro/node-server.mjs';
import 'node:http';
import 'node:https';
import 'node:zlib';
import 'node:stream';
import 'node:buffer';
import 'node:util';
import 'node:url';
import 'node:net';
import 'node:fs';
import 'node:path';
import 'fs';
import 'path';
import '@unhead/shared';
import 'vue-router';

const _sfc_main = defineComponent({
  name: "content",
  data() {
    return {
      videos: [{ "title": "DA DA DA DA I AM THE WANDERER", "id": "aemDy_yHPXU", "thumbnail": "https://i.ytimg.com/vi/aemDy_yHPXU/mqdefault.jpg", "date": "2023-11-23T18:38:04Z", "description": "Drum cover of The Wanderer by @TakanashiKiara." }, { "title": "Takanashi Kaira - The Wanderer Drum Cover", "id": "6_vT1P_e0vI", "thumbnail": "https://i.ytimg.com/vi/6_vT1P_e0vI/mqdefault.jpg", "date": "2023-11-23T18:27:01Z", "description": "A drum cover of The Wanderer by @TakanashiKiara." }, { "title": "The Who - The Real Me Drum Cover", "id": "8m_pqp--T4s", "thumbnail": "https://i.ytimg.com/vi/8m_pqp--T4s/mqdefault.jpg", "date": "2023-11-23T16:13:28Z", "description": "Check my channel for the full video." }, { "title": "The Who - The Real Me Drum Cover", "id": "L06pcktyxMo", "thumbnail": "https://i.ytimg.com/vi/L06pcktyxMo/mqdefault.jpg", "date": "2023-11-23T16:10:11Z", "description": "Decided to start uploading some of the songs I play on drums, been playing for a little over and its really just a hobby for me." }, { "title": "Playing Hypixel Skywars until get carried for free wins (I suck)", "id": "MDQRTEkUmG0", "thumbnail": "https://i.ytimg.com/vi/MDQRTEkUmG0/mqdefault.jpg", "date": "2023-07-09T07:23:22Z", "description": "Actually unstoppable Website: https://Bossslime.com/ Discord: https://discord.Bossslime.com/ Donate if you really don't have ..." }]
    };
  },
  selectedPage: {
    type: Number,
    default: 0
    //1-4 - 0 is none
  },
  methods: {
    formatDate(date) {
      return new Date(date).toLocaleDateString();
    },
    formatTime(date) {
      return new Date(date).toLocaleTimeString();
    }
  },
  async mounted() {
    try {
      const response = await $fetch("https://api.bossslime.com/get/recent_vids");
      this.videos = await response.json();
    } catch (e) {
      console.error(e);
    }
  }
});
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_NuxtLayout = __nuxt_component_0;
  _push(ssrRenderComponent(_component_NuxtLayout, mergeProps({
    name: "default",
    selectedPage: 2
  }, _attrs), {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<div class="body-content-container" data-v-36c5b6e1${_scopeId}><!--[-->`);
        ssrRenderList(_ctx.videos, (video) => {
          _push2(`<div class="body-content-object" data-v-36c5b6e1${_scopeId}><a${ssrRenderAttr("href", video.url)} class="body-content-object-title" data-v-36c5b6e1${_scopeId}>${ssrInterpolate(video.title)}</a><p class="body-content-object-subtitle" data-v-36c5b6e1${_scopeId}>${ssrInterpolate(_ctx.formatTime(video.date))} - ${ssrInterpolate(_ctx.formatDate(video.date))} \u2022 <a${ssrRenderAttr("href", video.thumbnail)} data-v-36c5b6e1${_scopeId}>Thumbnail</a></p><div class="body-content-object-divider" data-v-36c5b6e1${_scopeId}></div><div class="body-content-object-row-container" data-v-36c5b6e1${_scopeId}><div class="body-content-object-embed" data-v-36c5b6e1${_scopeId}><iframe${ssrRenderAttr("src", "https://www.youtube.com/embed/" + video.id + "?si=D5_oHB2_Rx_uuWux")} title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen data-v-36c5b6e1${_scopeId}></iframe></div><div class="body-content-object-description" data-v-36c5b6e1${_scopeId}>${ssrInterpolate(video.description)}</div></div></div>`);
        });
        _push2(`<!--]--></div>`);
      } else {
        return [
          createVNode("div", { class: "body-content-container" }, [
            (openBlock(true), createBlock(Fragment, null, renderList(_ctx.videos, (video) => {
              return openBlock(), createBlock("div", { class: "body-content-object" }, [
                createVNode("a", {
                  href: video.url,
                  class: "body-content-object-title"
                }, toDisplayString(video.title), 9, ["href"]),
                createVNode("p", { class: "body-content-object-subtitle" }, [
                  createTextVNode(toDisplayString(_ctx.formatTime(video.date)) + " - " + toDisplayString(_ctx.formatDate(video.date)) + " \u2022 ", 1),
                  createVNode("a", {
                    href: video.thumbnail
                  }, "Thumbnail", 8, ["href"])
                ]),
                createVNode("div", { class: "body-content-object-divider" }),
                createVNode("div", { class: "body-content-object-row-container" }, [
                  createVNode("div", { class: "body-content-object-embed" }, [
                    createVNode("iframe", {
                      src: "https://www.youtube.com/embed/" + video.id + "?si=D5_oHB2_Rx_uuWux",
                      title: "YouTube video player",
                      frameborder: "0",
                      allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
                      allowfullscreen: ""
                    }, null, 8, ["src"])
                  ]),
                  createVNode("div", { class: "body-content-object-description" }, toDisplayString(video.description), 1)
                ])
              ]);
            }), 256))
          ])
        ];
      }
    }),
    _: 1
  }, _parent));
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/content.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const content = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender], ["__scopeId", "data-v-36c5b6e1"]]);

export { content as default };
//# sourceMappingURL=content-0c77cdf5.mjs.map
