import { p as propsFactory, s as omit, g as genericComponent, I as IconValue, t as makeDisplayProps, e as useRtl, v as useDisplay, b as useProxiedModel, y as provideDefaults, h as convertToUnit, m as makeThemeProps, d as provideTheme, u as useLocale, _ as _export_sfc, x as focusableChildren, o as clamp, z as isObject, r as keys, q as __nuxt_component_0 } from '../server.mjs';
import { defineComponent, useSSRContext, computed, shallowRef, ref, createVNode, mergeProps, Fragment, toRef, watch, provide, withDirectives, resolveDirective, inject, vShow, nextTick, withCtx, createTextVNode, TransitionGroup, openBlock, createBlock } from 'vue';
import { ssrRenderComponent, ssrRenderAttrs, ssrRenderStyle, ssrRenderAttr, ssrGetDirectiveProps, ssrInterpolate, ssrRenderList, ssrRenderClass } from 'vue/server-renderer';
import { p as makeVBtnProps, g as useTextColor, u as useRender, l as VBtn, m as makeComponentProps, q as makeTagProps, r as makeGroupProps, t as useGroup, v as useResizeObserver, w as VFadeTransition, o as VIcon, j as makeDensityProps, k as useDensity, f as useBackgroundColor, x as makeGroupItemProps, y as useGroupItem, M as MaybeTransition, h as animate, s as standardEasing, R as Ripple } from './transition-138dedc4.mjs';
import AOS from 'aos';
import { m as makeLazyProps, u as useSsrBoot, a as useLazy } from './ssrBoot-d663a1e1.mjs';
import '../../nitro/node-server.mjs';
import 'node:http';
import 'node:https';
import 'node:zlib';
import 'node:stream';
import 'node:buffer';
import 'node:util';
import 'node:url';
import 'node:net';
import 'node:fs';
import 'node:path';
import 'fs';
import 'path';
import '@unhead/shared';
import 'vue-router';

const handleGesture = (wrapper) => {
  const {
    touchstartX,
    touchendX,
    touchstartY,
    touchendY
  } = wrapper;
  const dirRatio = 0.5;
  const minDistance = 16;
  wrapper.offsetX = touchendX - touchstartX;
  wrapper.offsetY = touchendY - touchstartY;
  if (Math.abs(wrapper.offsetY) < dirRatio * Math.abs(wrapper.offsetX)) {
    wrapper.left && touchendX < touchstartX - minDistance && wrapper.left(wrapper);
    wrapper.right && touchendX > touchstartX + minDistance && wrapper.right(wrapper);
  }
  if (Math.abs(wrapper.offsetX) < dirRatio * Math.abs(wrapper.offsetY)) {
    wrapper.up && touchendY < touchstartY - minDistance && wrapper.up(wrapper);
    wrapper.down && touchendY > touchstartY + minDistance && wrapper.down(wrapper);
  }
};
function touchstart(event, wrapper) {
  var _a;
  const touch = event.changedTouches[0];
  wrapper.touchstartX = touch.clientX;
  wrapper.touchstartY = touch.clientY;
  (_a = wrapper.start) == null ? void 0 : _a.call(wrapper, {
    originalEvent: event,
    ...wrapper
  });
}
function touchend(event, wrapper) {
  var _a;
  const touch = event.changedTouches[0];
  wrapper.touchendX = touch.clientX;
  wrapper.touchendY = touch.clientY;
  (_a = wrapper.end) == null ? void 0 : _a.call(wrapper, {
    originalEvent: event,
    ...wrapper
  });
  handleGesture(wrapper);
}
function touchmove(event, wrapper) {
  var _a;
  const touch = event.changedTouches[0];
  wrapper.touchmoveX = touch.clientX;
  wrapper.touchmoveY = touch.clientY;
  (_a = wrapper.move) == null ? void 0 : _a.call(wrapper, {
    originalEvent: event,
    ...wrapper
  });
}
function createHandlers() {
  let value = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
  const wrapper = {
    touchstartX: 0,
    touchstartY: 0,
    touchendX: 0,
    touchendY: 0,
    touchmoveX: 0,
    touchmoveY: 0,
    offsetX: 0,
    offsetY: 0,
    left: value.left,
    right: value.right,
    up: value.up,
    down: value.down,
    start: value.start,
    move: value.move,
    end: value.end
  };
  return {
    touchstart: (e) => touchstart(e, wrapper),
    touchend: (e) => touchend(e, wrapper),
    touchmove: (e) => touchmove(e, wrapper)
  };
}
function mounted(el, binding) {
  var _a2, _b;
  var _a;
  const value = binding.value;
  const target = (value == null ? void 0 : value.parent) ? el.parentElement : el;
  const options = (_a2 = value == null ? void 0 : value.options) != null ? _a2 : {
    passive: true
  };
  const uid = (_a = binding.instance) == null ? void 0 : _a.$.uid;
  if (!target || !uid)
    return;
  const handlers = createHandlers(binding.value);
  target._touchHandlers = (_b = target._touchHandlers) != null ? _b : /* @__PURE__ */ Object.create(null);
  target._touchHandlers[uid] = handlers;
  keys(handlers).forEach((eventName) => {
    target.addEventListener(eventName, handlers[eventName], options);
  });
}
function unmounted(el, binding) {
  var _a, _b;
  const target = ((_a = binding.value) == null ? void 0 : _a.parent) ? el.parentElement : el;
  const uid = (_b = binding.instance) == null ? void 0 : _b.$.uid;
  if (!(target == null ? void 0 : target._touchHandlers) || !uid)
    return;
  const handlers = target._touchHandlers[uid];
  keys(handlers).forEach((eventName) => {
    target.removeEventListener(eventName, handlers[eventName]);
  });
  delete target._touchHandlers[uid];
}
const Touch = {
  mounted,
  unmounted
};
const Touch$1 = Touch;
const _sfc_main$1 = defineComponent({
  name: "vprojectcarousel",
  props: {
    projects: {
      type: Array,
      required: true
    }
  },
  data() {
    return {
      parent: this.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent,
      isMobile: true
    };
  },
  methods: {
    getStatusColor(status) {
      switch (status.toLowerCase()) {
        case "active":
          return "#21ba45";
        case "dormant":
          return "#fbbd08";
        case "inactive":
          return "#db2828";
      }
    },
    userClickOnTag(tag) {
      this.parent.infoTab = 2;
    },
    //Opens up a bigger view of the description
    userClickOnDescription(project) {
      if (this.parent.clickedProject !== void 0 && this.parent.clickedProject.name === project.name) {
        this.parent.clickedProject = void 0;
      } else {
        this.parent.clickedProject = project;
      }
    },
    /* This ONLY redirects when the user clicks a button, so no force redirects here folks :) */
    openWindowForUser(url) {
      window.open(url, "_blank");
    }
  },
  computed: {
    skills() {
      return this.parent.skills;
    },
    clickedProject() {
      return this.parent.clickedProject;
    }
  },
  mounted() {
    const bodyElement = document.querySelector("body");
    const projectCarousel = document.getElementById("project-carousel");
    const projects2 = document.getElementById("projects-2");
    let i = 0;
    const parent = this.parent;
    const scrollProjectCarousel = () => {
      if (bodyElement.clientWidth >= 1e3) {
        this.isMobile = false;
        if (parent.infoTab === 1) {
          const scrollWidth = projects2.clientWidth;
          if (parent.clickedProject == void 0) {
            i++;
            if (i === 5) {
              projectCarousel.scrollLeft += 1;
              i = 0;
            }
          }
          const scrollLeft = projectCarousel.scrollLeft;
          const clientWidth = projectCarousel.clientWidth;
          if (scrollLeft + clientWidth <= scrollWidth) {
            projectCarousel.scrollLeft = scrollWidth * 2 - clientWidth - (scrollWidth - (scrollLeft + clientWidth));
          } else if (scrollLeft >= scrollWidth * 2) {
            projectCarousel.scrollLeft = scrollWidth + (scrollLeft - scrollWidth * 2);
          }
        }
      } else {
        this.isMobile = true;
      }
      requestAnimationFrame(scrollProjectCarousel);
    };
    requestAnimationFrame(scrollProjectCarousel);
  }
});
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<!--[--><div class="project-container-wrapper" style="${ssrRenderStyle(!_ctx.isMobile ? null : { display: "none" })}" data-v-6d84eb42>`);
  if (_ctx.clickedProject !== void 0) {
    _push(`<div class="clicked-project-container" data-v-6d84eb42><div class="clicked-project-info-container" data-v-6d84eb42><div class="clicked-project-left" data-v-6d84eb42><img${ssrRenderAttr("src", "logos/" + _ctx.clickedProject.logo)} class="clicked-project-logo" alt="" data-v-6d84eb42><div class="project-object-socials-container" data-v-6d84eb42>`);
    if (_ctx.clickedProject.discord != void 0) {
      _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg xmlns="http://www.w3.org/2000/svg" fill="#7289DA" viewBox="0 0 640 512" data-v-6d84eb42><path d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z" data-v-6d84eb42></path></svg></div></a>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.clickedProject.gitRepo != void 0) {
      _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" data-v-6d84eb42><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z" data-v-6d84eb42></path></svg></div></a>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.clickedProject.website != void 0) {
      _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg" stroke-width="3" stroke="#000000" fill="none" data-v-6d84eb42><path d="M39.93,55.72A24.86,24.86,0,1,1,56.86,32.15a37.24,37.24,0,0,1-.73,6" data-v-6d84eb42></path><path d="M37.86,51.1A47,47,0,0,1,32,56.7" data-v-6d84eb42></path><path d="M32,7A34.14,34.14,0,0,1,43.57,30a34.07,34.07,0,0,1,.09,4.85" data-v-6d84eb42></path><path d="M32,7A34.09,34.09,0,0,0,20.31,32.46c0,16.2,7.28,21,11.66,24.24" data-v-6d84eb42></path><line x1="10.37" y1="19.9" x2="53.75" y2="19.9" data-v-6d84eb42></line><line x1="32" y1="6.99" x2="32" y2="56.7" data-v-6d84eb42></line><line x1="11.05" y1="45.48" x2="37.04" y2="45.48" data-v-6d84eb42></line><line x1="7.14" y1="32.46" x2="56.86" y2="31.85" data-v-6d84eb42></line><path d="M53.57,57,58,52.56l-8-8,4.55-2.91a.38.38,0,0,0-.12-.7L39.14,37.37a.39.39,0,0,0-.46.46L42,53.41a.39.39,0,0,0,.71.13L45.57,49Z" data-v-6d84eb42></path></svg></div></a>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></div><div class="clicked-project-middle" data-v-6d84eb42><h1 data-v-6d84eb42>${ssrInterpolate(_ctx.clickedProject.name)}</h1><p data-v-6d84eb42>${ssrInterpolate(_ctx.clickedProject.description)}</p></div><div class="clicked-project-right" data-v-6d84eb42><!--[-->`);
    ssrRenderList(_ctx.clickedProject.tags, (tag) => {
      _push(`<div class="project-tag-container" style="${ssrRenderStyle([{ "border-color": _ctx.skills.find((skill) => skill.name === tag).color }])}" data-v-6d84eb42><div class="project-tag-dot" style="${ssrRenderStyle({ "background-color": _ctx.skills.find((skill) => skill.name === tag).color })}" data-v-6d84eb42></div> ${ssrInterpolate(tag)}</div>`);
    });
    _push(`<!--]--></div></div></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`<div class="project-container" id="project-carousel" data-v-6d84eb42><!--[-->`);
  ssrRenderList(3, (i) => {
    _push(`<div class="project-object-container"${ssrRenderAttr("id", "projects-" + i)} data-v-6d84eb42><!--[-->`);
    ssrRenderList(_ctx.projects, (project) => {
      _push(`<div class="${ssrRenderClass(_ctx.clickedProject && project.name === _ctx.clickedProject.name ? "project-object-clicked" : "project-object")}" data-v-6d84eb42><div class="project-object-left" data-v-6d84eb42><img${ssrRenderAttr("src", "logos/" + project.logo)} class="project-object-logo" alt="" data-v-6d84eb42><div class="project-object-socials-container" data-v-6d84eb42>`);
      if (project.discord != void 0) {
        _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg xmlns="http://www.w3.org/2000/svg" fill="#7289DA" viewBox="0 0 640 512" data-v-6d84eb42><path d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z" data-v-6d84eb42></path></svg></div></a>`);
      } else {
        _push(`<!---->`);
      }
      if (project.gitRepo != void 0) {
        _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" data-v-6d84eb42><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z" data-v-6d84eb42></path></svg></div></a>`);
      } else {
        _push(`<!---->`);
      }
      if (project.website != void 0) {
        _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg" stroke-width="3" stroke="#000000" fill="none" data-v-6d84eb42><path d="M39.93,55.72A24.86,24.86,0,1,1,56.86,32.15a37.24,37.24,0,0,1-.73,6" data-v-6d84eb42></path><path d="M37.86,51.1A47,47,0,0,1,32,56.7" data-v-6d84eb42></path><path d="M32,7A34.14,34.14,0,0,1,43.57,30a34.07,34.07,0,0,1,.09,4.85" data-v-6d84eb42></path><path d="M32,7A34.09,34.09,0,0,0,20.31,32.46c0,16.2,7.28,21,11.66,24.24" data-v-6d84eb42></path><line x1="10.37" y1="19.9" x2="53.75" y2="19.9" data-v-6d84eb42></line><line x1="32" y1="6.99" x2="32" y2="56.7" data-v-6d84eb42></line><line x1="11.05" y1="45.48" x2="37.04" y2="45.48" data-v-6d84eb42></line><line x1="7.14" y1="32.46" x2="56.86" y2="31.85" data-v-6d84eb42></line><path d="M53.57,57,58,52.56l-8-8,4.55-2.91a.38.38,0,0,0-.12-.7L39.14,37.37a.39.39,0,0,0-.46.46L42,53.41a.39.39,0,0,0,.71.13L45.57,49Z" data-v-6d84eb42></path></svg></div></a>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="project-object-right" data-v-6d84eb42><div class="project-object-status" style="${ssrRenderStyle({ backgroundColor: _ctx.getStatusColor(project.status) })}"${ssrRenderAttr("title", "This project is currently " + project.status)} data-v-6d84eb42></div><h1 data-v-6d84eb42>${ssrInterpolate(project.name)}</h1><div class="project-object-right-description" data-v-6d84eb42><p data-v-6d84eb42>${ssrInterpolate(project.description)}</p></div><div class="project-right-tag-container" data-v-6d84eb42><!--[-->`);
      ssrRenderList(project.tags, (tag) => {
        _push(`<div class="project-tag-container" style="${ssrRenderStyle([{ "border-color": _ctx.skills.find((skill) => skill.name === tag).color }])}" data-v-6d84eb42><div class="project-tag-dot" style="${ssrRenderStyle({ "background-color": _ctx.skills.find((skill) => skill.name === tag).color })}" data-v-6d84eb42></div> ${ssrInterpolate(tag)}</div>`);
      });
      _push(`<!--]--></div></div></div>`);
    });
    _push(`<!--]--></div>`);
  });
  _push(`<!--]--></div></div><div class="project-mobile-container" style="${ssrRenderStyle(_ctx.isMobile ? null : { display: "none" })}" data-v-6d84eb42><!--[-->`);
  ssrRenderList(_ctx.projects, (project) => {
    _push(`<div class="project-mobile-object" data-v-6d84eb42><div class="project-object-left" data-v-6d84eb42><img${ssrRenderAttr("src", "logos/" + project.logo)} class="project-object-logo" alt="" data-v-6d84eb42><div class="project-object-socials-container" data-v-6d84eb42>`);
    if (project.discord != void 0) {
      _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg xmlns="http://www.w3.org/2000/svg" fill="#7289DA" viewBox="0 0 640 512" data-v-6d84eb42><path d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z" data-v-6d84eb42></path></svg></div></a>`);
    } else {
      _push(`<!---->`);
    }
    if (project.gitRepo != void 0) {
      _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" data-v-6d84eb42><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z" data-v-6d84eb42></path></svg></div></a>`);
    } else {
      _push(`<!---->`);
    }
    if (project.website != void 0) {
      _push(`<a target="_blank" data-v-6d84eb42><div${ssrRenderAttrs(mergeProps({ class: "project-object-socials-button text-secondary" }, ssrGetDirectiveProps(_ctx, Ripple, void 0, void 0, { center: true })))} data-v-6d84eb42><svg viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg" stroke-width="3" stroke="#000000" fill="none" data-v-6d84eb42><path d="M39.93,55.72A24.86,24.86,0,1,1,56.86,32.15a37.24,37.24,0,0,1-.73,6" data-v-6d84eb42></path><path d="M37.86,51.1A47,47,0,0,1,32,56.7" data-v-6d84eb42></path><path d="M32,7A34.14,34.14,0,0,1,43.57,30a34.07,34.07,0,0,1,.09,4.85" data-v-6d84eb42></path><path d="M32,7A34.09,34.09,0,0,0,20.31,32.46c0,16.2,7.28,21,11.66,24.24" data-v-6d84eb42></path><line x1="10.37" y1="19.9" x2="53.75" y2="19.9" data-v-6d84eb42></line><line x1="32" y1="6.99" x2="32" y2="56.7" data-v-6d84eb42></line><line x1="11.05" y1="45.48" x2="37.04" y2="45.48" data-v-6d84eb42></line><line x1="7.14" y1="32.46" x2="56.86" y2="31.85" data-v-6d84eb42></line><path d="M53.57,57,58,52.56l-8-8,4.55-2.91a.38.38,0,0,0-.12-.7L39.14,37.37a.39.39,0,0,0-.46.46L42,53.41a.39.39,0,0,0,.71.13L45.57,49Z" data-v-6d84eb42></path></svg></div></a>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></div><div class="project-object-right" data-v-6d84eb42><div class="project-object-status" style="${ssrRenderStyle({ backgroundColor: _ctx.getStatusColor(project.status) })}"${ssrRenderAttr("title", "This project is currently " + project.status)} data-v-6d84eb42></div><h1 data-v-6d84eb42>${ssrInterpolate(project.name)}</h1><div class="project-mobile-object-right-description" data-v-6d84eb42><p data-v-6d84eb42>${ssrInterpolate(project.description)}</p></div><div class="project-right-tag-container" data-v-6d84eb42><!--[-->`);
    ssrRenderList(project.tags, (tag) => {
      _push(`<div class="project-tag-container" style="${ssrRenderStyle([{ "border-color": _ctx.skills.find((skill) => skill.name === tag).color }])}" data-v-6d84eb42><div class="project-tag-dot" style="${ssrRenderStyle({ "background-color": _ctx.skills.find((skill) => skill.name === tag).color })}" data-v-6d84eb42></div> ${ssrInterpolate(tag)}</div>`);
    });
    _push(`<!--]--></div></div></div>`);
  });
  _push(`<!--]--></div><!--]-->`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/vprojectcarousel.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender$1], ["__scopeId", "data-v-6d84eb42"]]);
const VTabsSymbol = Symbol.for("vuetify:v-tabs");
const makeVTabProps = propsFactory({
  fixed: Boolean,
  sliderColor: String,
  hideSlider: Boolean,
  direction: {
    type: String,
    default: "horizontal"
  },
  ...omit(makeVBtnProps({
    selectedClass: "v-tab--selected",
    variant: "text"
  }), ["active", "block", "flat", "location", "position", "symbol"])
}, "VTab");
const VTab = genericComponent()({
  name: "VTab",
  props: makeVTabProps(),
  setup(props, _ref) {
    let {
      slots,
      attrs
    } = _ref;
    const {
      textColorClasses: sliderColorClasses,
      textColorStyles: sliderColorStyles
    } = useTextColor(props, "sliderColor");
    const isHorizontal = computed(() => props.direction === "horizontal");
    const isSelected = shallowRef(false);
    const rootEl = ref();
    const sliderEl = ref();
    function updateSlider(_ref2) {
      var _a, _b;
      let {
        value
      } = _ref2;
      isSelected.value = value;
      if (value) {
        const prevEl = (_b = (_a = rootEl.value) == null ? void 0 : _a.$el.parentElement) == null ? void 0 : _b.querySelector(".v-tab--selected .v-tab__slider");
        const nextEl = sliderEl.value;
        if (!prevEl || !nextEl)
          return;
        const color = getComputedStyle(prevEl).color;
        const prevBox = prevEl.getBoundingClientRect();
        const nextBox = nextEl.getBoundingClientRect();
        const xy = isHorizontal.value ? "x" : "y";
        const XY = isHorizontal.value ? "X" : "Y";
        const rightBottom = isHorizontal.value ? "right" : "bottom";
        const widthHeight = isHorizontal.value ? "width" : "height";
        const prevPos = prevBox[xy];
        const nextPos = nextBox[xy];
        const delta = prevPos > nextPos ? prevBox[rightBottom] - nextBox[rightBottom] : prevBox[xy] - nextBox[xy];
        const origin = Math.sign(delta) > 0 ? isHorizontal.value ? "right" : "bottom" : Math.sign(delta) < 0 ? isHorizontal.value ? "left" : "top" : "center";
        const size = Math.abs(delta) + (Math.sign(delta) < 0 ? prevBox[widthHeight] : nextBox[widthHeight]);
        const scale = size / Math.max(prevBox[widthHeight], nextBox[widthHeight]) || 0;
        const initialScale = prevBox[widthHeight] / nextBox[widthHeight] || 0;
        const sigma = 1.5;
        animate(nextEl, {
          backgroundColor: [color, "currentcolor"],
          transform: [`translate${XY}(${delta}px) scale${XY}(${initialScale})`, `translate${XY}(${delta / sigma}px) scale${XY}(${(scale - 1) / sigma + 1})`, "none"],
          transformOrigin: Array(3).fill(origin)
        }, {
          duration: 225,
          easing: standardEasing
        });
      }
    }
    useRender(() => {
      const btnProps = VBtn.filterProps(props);
      return createVNode(VBtn, mergeProps({
        "symbol": VTabsSymbol,
        "ref": rootEl,
        "class": ["v-tab", props.class],
        "style": props.style,
        "tabindex": isSelected.value ? 0 : -1,
        "role": "tab",
        "aria-selected": String(isSelected.value),
        "active": false
      }, btnProps, attrs, {
        "block": props.fixed,
        "maxWidth": props.fixed ? 300 : void 0,
        "onGroup:selected": updateSlider
      }), {
        ...slots,
        default: () => {
          var _a2;
          var _a;
          return createVNode(Fragment, null, [(_a2 = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _a2 : props.text, !props.hideSlider && createVNode("div", {
            "ref": sliderEl,
            "class": ["v-tab__slider", sliderColorClasses.value],
            "style": sliderColorStyles.value
          }, null)]);
        }
      });
    });
    return {};
  }
});
function bias(val) {
  const c = 0.501;
  const x = Math.abs(val);
  return Math.sign(val) * (x / ((1 / c - 2) * (1 - x) + 1));
}
function calculateUpdatedOffset(_ref) {
  let {
    selectedElement,
    containerSize,
    contentSize,
    isRtl,
    currentScrollOffset,
    isHorizontal
  } = _ref;
  const clientSize = isHorizontal ? selectedElement.clientWidth : selectedElement.clientHeight;
  const offsetStart = isHorizontal ? selectedElement.offsetLeft : selectedElement.offsetTop;
  const adjustedOffsetStart = isRtl && isHorizontal ? contentSize - offsetStart - clientSize : offsetStart;
  const totalSize = containerSize + currentScrollOffset;
  const itemOffset = clientSize + adjustedOffsetStart;
  const additionalOffset = clientSize * 0.4;
  if (adjustedOffsetStart <= currentScrollOffset) {
    currentScrollOffset = Math.max(adjustedOffsetStart - additionalOffset, 0);
  } else if (totalSize <= itemOffset) {
    currentScrollOffset = Math.min(currentScrollOffset - (totalSize - itemOffset - additionalOffset), contentSize - containerSize);
  }
  return currentScrollOffset;
}
const VSlideGroupSymbol = Symbol.for("vuetify:v-slide-group");
const makeVSlideGroupProps = propsFactory({
  centerActive: Boolean,
  direction: {
    type: String,
    default: "horizontal"
  },
  symbol: {
    type: null,
    default: VSlideGroupSymbol
  },
  nextIcon: {
    type: IconValue,
    default: "$next"
  },
  prevIcon: {
    type: IconValue,
    default: "$prev"
  },
  showArrows: {
    type: [Boolean, String],
    validator: (v) => typeof v === "boolean" || ["always", "desktop", "mobile"].includes(v)
  },
  ...makeComponentProps(),
  ...makeDisplayProps(),
  ...makeTagProps(),
  ...makeGroupProps({
    selectedClass: "v-slide-group-item--active"
  })
}, "VSlideGroup");
const VSlideGroup = genericComponent()({
  name: "VSlideGroup",
  props: makeVSlideGroupProps(),
  emits: {
    "update:modelValue": (value) => true
  },
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      isRtl
    } = useRtl();
    const {
      displayClasses,
      mobile
    } = useDisplay(props);
    const group = useGroup(props, props.symbol);
    const isOverflowing = shallowRef(false);
    const scrollOffset = shallowRef(0);
    const containerSize = shallowRef(0);
    const contentSize = shallowRef(0);
    const isHorizontal = computed(() => props.direction === "horizontal");
    const {
      resizeRef: containerRef,
      contentRect: containerRect
    } = useResizeObserver();
    const {
      resizeRef: contentRef,
      contentRect
    } = useResizeObserver();
    computed(() => {
      if (!group.selected.value.length)
        return -1;
      return group.items.value.findIndex((item) => item.id === group.selected.value[0]);
    });
    computed(() => {
      if (!group.selected.value.length)
        return -1;
      return group.items.value.findIndex((item) => item.id === group.selected.value[group.selected.value.length - 1]);
    });
    const disableTransition = shallowRef(false);
    let startTouch = 0;
    let startOffset = 0;
    function onTouchstart(e) {
      const sizeProperty = isHorizontal.value ? "clientX" : "clientY";
      const sign = isRtl.value && isHorizontal.value ? -1 : 1;
      startOffset = sign * scrollOffset.value;
      startTouch = e.touches[0][sizeProperty];
      disableTransition.value = true;
    }
    function onTouchmove(e) {
      if (!isOverflowing.value)
        return;
      const sizeProperty = isHorizontal.value ? "clientX" : "clientY";
      const sign = isRtl.value && isHorizontal.value ? -1 : 1;
      scrollOffset.value = sign * (startOffset + startTouch - e.touches[0][sizeProperty]);
    }
    function onTouchend(e) {
      const maxScrollOffset = contentSize.value - containerSize.value;
      if (scrollOffset.value < 0 || !isOverflowing.value) {
        scrollOffset.value = 0;
      } else if (scrollOffset.value >= maxScrollOffset) {
        scrollOffset.value = maxScrollOffset;
      }
      disableTransition.value = false;
    }
    function onScroll() {
      if (!containerRef.value)
        return;
      containerRef.value[isHorizontal.value ? "scrollLeft" : "scrollTop"] = 0;
    }
    const isFocused = shallowRef(false);
    function onFocusin(e) {
      isFocused.value = true;
      if (!isOverflowing.value || !contentRef.value)
        return;
      for (const el of e.composedPath()) {
        for (const item of contentRef.value.children) {
          if (item === el) {
            scrollOffset.value = calculateUpdatedOffset({
              selectedElement: item,
              containerSize: containerSize.value,
              contentSize: contentSize.value,
              isRtl: isRtl.value,
              currentScrollOffset: scrollOffset.value,
              isHorizontal: isHorizontal.value
            });
            return;
          }
        }
      }
    }
    function onFocusout(e) {
      isFocused.value = false;
    }
    function onFocus(e) {
      var _a;
      if (!isFocused.value && !(e.relatedTarget && ((_a = contentRef.value) == null ? void 0 : _a.contains(e.relatedTarget))))
        focus();
    }
    function onKeydown(e) {
      if (!contentRef.value)
        return;
      if (isHorizontal.value) {
        if (e.key === "ArrowRight") {
          focus(isRtl.value ? "prev" : "next");
        } else if (e.key === "ArrowLeft") {
          focus(isRtl.value ? "next" : "prev");
        }
      } else {
        if (e.key === "ArrowDown") {
          focus("next");
        } else if (e.key === "ArrowUp") {
          focus("prev");
        }
      }
      if (e.key === "Home") {
        focus("first");
      } else if (e.key === "End") {
        focus("last");
      }
    }
    function focus(location) {
      var _a, _b, _c, _d, _e;
      if (!contentRef.value)
        return;
      if (!location) {
        const focusable = focusableChildren(contentRef.value);
        (_a = focusable[0]) == null ? void 0 : _a.focus();
      } else if (location === "next") {
        const el = (_b = contentRef.value.querySelector(":focus")) == null ? void 0 : _b.nextElementSibling;
        if (el)
          el.focus();
        else
          focus("first");
      } else if (location === "prev") {
        const el = (_c = contentRef.value.querySelector(":focus")) == null ? void 0 : _c.previousElementSibling;
        if (el)
          el.focus();
        else
          focus("last");
      } else if (location === "first") {
        (_d = contentRef.value.firstElementChild) == null ? void 0 : _d.focus();
      } else if (location === "last") {
        (_e = contentRef.value.lastElementChild) == null ? void 0 : _e.focus();
      }
    }
    function scrollTo(location) {
      const newAbsoluteOffset = scrollOffset.value + (location === "prev" ? -1 : 1) * containerSize.value;
      scrollOffset.value = clamp(newAbsoluteOffset, 0, contentSize.value - containerSize.value);
    }
    const contentStyles = computed(() => {
      let scrollAmount = scrollOffset.value > contentSize.value - containerSize.value ? -(contentSize.value - containerSize.value) + bias(contentSize.value - containerSize.value - scrollOffset.value) : -scrollOffset.value;
      if (scrollOffset.value <= 0) {
        scrollAmount = bias(-scrollOffset.value);
      }
      const sign = isRtl.value && isHorizontal.value ? -1 : 1;
      return {
        transform: `translate${isHorizontal.value ? "X" : "Y"}(${sign * scrollAmount}px)`,
        transition: disableTransition.value ? "none" : "",
        willChange: disableTransition.value ? "transform" : ""
      };
    });
    const slotProps = computed(() => ({
      next: group.next,
      prev: group.prev,
      select: group.select,
      isSelected: group.isSelected
    }));
    const hasAffixes = computed(() => {
      switch (props.showArrows) {
        case "always":
          return true;
        case "desktop":
          return !mobile.value;
        case true:
          return isOverflowing.value || Math.abs(scrollOffset.value) > 0;
        case "mobile":
          return mobile.value || isOverflowing.value || Math.abs(scrollOffset.value) > 0;
        default:
          return !mobile.value && (isOverflowing.value || Math.abs(scrollOffset.value) > 0);
      }
    });
    const hasPrev = computed(() => {
      return Math.abs(scrollOffset.value) > 0;
    });
    const hasNext = computed(() => {
      return contentSize.value > Math.abs(scrollOffset.value) + containerSize.value;
    });
    useRender(() => createVNode(props.tag, {
      "class": ["v-slide-group", {
        "v-slide-group--vertical": !isHorizontal.value,
        "v-slide-group--has-affixes": hasAffixes.value,
        "v-slide-group--is-overflowing": isOverflowing.value
      }, displayClasses.value, props.class],
      "style": props.style,
      "tabindex": isFocused.value || group.selected.value.length ? -1 : 0,
      "onFocus": onFocus
    }, {
      default: () => {
        var _a2, _b2;
        var _a, _b, _c;
        return [hasAffixes.value && createVNode("div", {
          "key": "prev",
          "class": ["v-slide-group__prev", {
            "v-slide-group__prev--disabled": !hasPrev.value
          }],
          "onClick": () => hasPrev.value && scrollTo("prev")
        }, [(_a2 = (_a = slots.prev) == null ? void 0 : _a.call(slots, slotProps.value)) != null ? _a2 : createVNode(VFadeTransition, null, {
          default: () => [createVNode(VIcon, {
            "icon": isRtl.value ? props.nextIcon : props.prevIcon
          }, null)]
        })]), createVNode("div", {
          "key": "container",
          "ref": containerRef,
          "class": "v-slide-group__container",
          "onScroll": onScroll
        }, [createVNode("div", {
          "ref": contentRef,
          "class": "v-slide-group__content",
          "style": contentStyles.value,
          "onTouchstartPassive": onTouchstart,
          "onTouchmovePassive": onTouchmove,
          "onTouchendPassive": onTouchend,
          "onFocusin": onFocusin,
          "onFocusout": onFocusout,
          "onKeydown": onKeydown
        }, [(_b = slots.default) == null ? void 0 : _b.call(slots, slotProps.value)])]), hasAffixes.value && createVNode("div", {
          "key": "next",
          "class": ["v-slide-group__next", {
            "v-slide-group__next--disabled": !hasNext.value
          }],
          "onClick": () => hasNext.value && scrollTo("next")
        }, [(_b2 = (_c = slots.next) == null ? void 0 : _c.call(slots, slotProps.value)) != null ? _b2 : createVNode(VFadeTransition, null, {
          default: () => [createVNode(VIcon, {
            "icon": isRtl.value ? props.prevIcon : props.nextIcon
          }, null)]
        })])];
      }
    }));
    return {
      selected: group.selected,
      scrollTo,
      scrollOffset,
      focus
    };
  }
});
function parseItems(items) {
  if (!items)
    return [];
  return items.map((item) => {
    if (!isObject(item))
      return {
        text: item,
        value: item
      };
    return item;
  });
}
const makeVTabsProps = propsFactory({
  alignTabs: {
    type: String,
    default: "start"
  },
  color: String,
  fixedTabs: Boolean,
  items: {
    type: Array,
    default: () => []
  },
  stacked: Boolean,
  bgColor: String,
  grow: Boolean,
  height: {
    type: [Number, String],
    default: void 0
  },
  hideSlider: Boolean,
  sliderColor: String,
  ...makeVSlideGroupProps({
    mandatory: "force"
  }),
  ...makeDensityProps(),
  ...makeTagProps()
}, "VTabs");
const VTabs = genericComponent()({
  name: "VTabs",
  props: makeVTabsProps(),
  emits: {
    "update:modelValue": (v) => true
  },
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const model = useProxiedModel(props, "modelValue");
    const parsedItems = computed(() => parseItems(props.items));
    const {
      densityClasses
    } = useDensity(props);
    const {
      backgroundColorClasses,
      backgroundColorStyles
    } = useBackgroundColor(toRef(props, "bgColor"));
    provideDefaults({
      VTab: {
        color: toRef(props, "color"),
        direction: toRef(props, "direction"),
        stacked: toRef(props, "stacked"),
        fixed: toRef(props, "fixedTabs"),
        sliderColor: toRef(props, "sliderColor"),
        hideSlider: toRef(props, "hideSlider")
      }
    });
    useRender(() => {
      const slideGroupProps = VSlideGroup.filterProps(props);
      return createVNode(VSlideGroup, mergeProps(slideGroupProps, {
        "modelValue": model.value,
        "onUpdate:modelValue": ($event) => model.value = $event,
        "class": ["v-tabs", `v-tabs--${props.direction}`, `v-tabs--align-tabs-${props.alignTabs}`, {
          "v-tabs--fixed-tabs": props.fixedTabs,
          "v-tabs--grow": props.grow,
          "v-tabs--stacked": props.stacked
        }, densityClasses.value, backgroundColorClasses.value, props.class],
        "style": [{
          "--v-tabs-height": convertToUnit(props.height)
        }, backgroundColorStyles.value, props.style],
        "role": "tablist",
        "symbol": VTabsSymbol
      }), {
        default: () => [slots.default ? slots.default() : parsedItems.value.map((item) => createVNode(VTab, mergeProps(item, {
          "key": item.text
        }), null))]
      });
    });
    return {};
  }
});
const VWindowSymbol = Symbol.for("vuetify:v-window");
const VWindowGroupSymbol = Symbol.for("vuetify:v-window-group");
const makeVWindowProps = propsFactory({
  continuous: Boolean,
  nextIcon: {
    type: [Boolean, String, Function, Object],
    default: "$next"
  },
  prevIcon: {
    type: [Boolean, String, Function, Object],
    default: "$prev"
  },
  reverse: Boolean,
  showArrows: {
    type: [Boolean, String],
    validator: (v) => typeof v === "boolean" || v === "hover"
  },
  touch: {
    type: [Object, Boolean],
    default: void 0
  },
  direction: {
    type: String,
    default: "horizontal"
  },
  modelValue: null,
  disabled: Boolean,
  selectedClass: {
    type: String,
    default: "v-window-item--active"
  },
  // TODO: mandatory should probably not be exposed but do this for now
  mandatory: {
    type: [Boolean, String],
    default: "force"
  },
  ...makeComponentProps(),
  ...makeTagProps(),
  ...makeThemeProps()
}, "VWindow");
const VWindow = genericComponent()({
  name: "VWindow",
  directives: {
    Touch
  },
  props: makeVWindowProps(),
  emits: {
    "update:modelValue": (value) => true
  },
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      themeClasses
    } = provideTheme(props);
    const {
      isRtl
    } = useRtl();
    const {
      t
    } = useLocale();
    const group = useGroup(props, VWindowGroupSymbol);
    const rootRef = ref();
    const isRtlReverse = computed(() => isRtl.value ? !props.reverse : props.reverse);
    const isReversed = shallowRef(false);
    const transition = computed(() => {
      const axis = props.direction === "vertical" ? "y" : "x";
      const reverse = isRtlReverse.value ? !isReversed.value : isReversed.value;
      const direction = reverse ? "-reverse" : "";
      return `v-window-${axis}${direction}-transition`;
    });
    const transitionCount = shallowRef(0);
    const transitionHeight = ref(void 0);
    const activeIndex = computed(() => {
      return group.items.value.findIndex((item) => group.selected.value.includes(item.id));
    });
    watch(activeIndex, (newVal, oldVal) => {
      const itemsLength = group.items.value.length;
      const lastIndex = itemsLength - 1;
      if (itemsLength <= 2) {
        isReversed.value = newVal < oldVal;
      } else if (newVal === lastIndex && oldVal === 0) {
        isReversed.value = true;
      } else if (newVal === 0 && oldVal === lastIndex) {
        isReversed.value = false;
      } else {
        isReversed.value = newVal < oldVal;
      }
    });
    provide(VWindowSymbol, {
      transition,
      isReversed,
      transitionCount,
      transitionHeight,
      rootRef
    });
    const canMoveBack = computed(() => props.continuous || activeIndex.value !== 0);
    const canMoveForward = computed(() => props.continuous || activeIndex.value !== group.items.value.length - 1);
    function prev() {
      canMoveBack.value && group.prev();
    }
    function next() {
      canMoveForward.value && group.next();
    }
    const arrows = computed(() => {
      const arrows2 = [];
      const prevProps = {
        icon: isRtl.value ? props.nextIcon : props.prevIcon,
        class: `v-window__${isRtlReverse.value ? "right" : "left"}`,
        onClick: group.prev,
        ariaLabel: t("$vuetify.carousel.prev")
      };
      arrows2.push(canMoveBack.value ? slots.prev ? slots.prev({
        props: prevProps
      }) : createVNode(VBtn, prevProps, null) : createVNode("div", null, null));
      const nextProps = {
        icon: isRtl.value ? props.prevIcon : props.nextIcon,
        class: `v-window__${isRtlReverse.value ? "left" : "right"}`,
        onClick: group.next,
        ariaLabel: t("$vuetify.carousel.next")
      };
      arrows2.push(canMoveForward.value ? slots.next ? slots.next({
        props: nextProps
      }) : createVNode(VBtn, nextProps, null) : createVNode("div", null, null));
      return arrows2;
    });
    const touchOptions = computed(() => {
      if (props.touch === false)
        return props.touch;
      const options = {
        left: () => {
          isRtlReverse.value ? prev() : next();
        },
        right: () => {
          isRtlReverse.value ? next() : prev();
        },
        start: (_ref2) => {
          let {
            originalEvent
          } = _ref2;
          originalEvent.stopPropagation();
        }
      };
      return {
        ...options,
        ...props.touch === true ? {} : props.touch
      };
    });
    useRender(() => withDirectives(createVNode(props.tag, {
      "ref": rootRef,
      "class": ["v-window", {
        "v-window--show-arrows-on-hover": props.showArrows === "hover"
      }, themeClasses.value, props.class],
      "style": props.style
    }, {
      default: () => {
        var _a, _b;
        return [createVNode("div", {
          "class": "v-window__container",
          "style": {
            height: transitionHeight.value
          }
        }, [(_a = slots.default) == null ? void 0 : _a.call(slots, {
          group
        }), props.showArrows !== false && createVNode("div", {
          "class": "v-window__controls"
        }, [arrows.value])]), (_b = slots.additional) == null ? void 0 : _b.call(slots, {
          group
        })];
      }
    }), [[resolveDirective("touch"), touchOptions.value]]));
    return {
      group
    };
  }
});
const makeVWindowItemProps = propsFactory({
  reverseTransition: {
    type: [Boolean, String],
    default: void 0
  },
  transition: {
    type: [Boolean, String],
    default: void 0
  },
  ...makeComponentProps(),
  ...makeGroupItemProps(),
  ...makeLazyProps()
}, "VWindowItem");
const VWindowItem = genericComponent()({
  name: "VWindowItem",
  directives: {
    Touch: Touch$1
  },
  props: makeVWindowItemProps(),
  emits: {
    "group:selected": (val) => true
  },
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const window2 = inject(VWindowSymbol);
    const groupItem = useGroupItem(props, VWindowGroupSymbol);
    const {
      isBooted
    } = useSsrBoot();
    if (!window2 || !groupItem)
      throw new Error("[Vuetify] VWindowItem must be used inside VWindow");
    const isTransitioning = shallowRef(false);
    const hasTransition = computed(() => isBooted.value && (window2.isReversed.value ? props.reverseTransition !== false : props.transition !== false));
    function onAfterTransition() {
      if (!isTransitioning.value || !window2) {
        return;
      }
      isTransitioning.value = false;
      if (window2.transitionCount.value > 0) {
        window2.transitionCount.value -= 1;
        if (window2.transitionCount.value === 0) {
          window2.transitionHeight.value = void 0;
        }
      }
    }
    function onBeforeTransition() {
      var _a;
      if (isTransitioning.value || !window2) {
        return;
      }
      isTransitioning.value = true;
      if (window2.transitionCount.value === 0) {
        window2.transitionHeight.value = convertToUnit((_a = window2.rootRef.value) == null ? void 0 : _a.clientHeight);
      }
      window2.transitionCount.value += 1;
    }
    function onTransitionCancelled() {
      onAfterTransition();
    }
    function onEnterTransition(el) {
      if (!isTransitioning.value) {
        return;
      }
      nextTick(() => {
        if (!hasTransition.value || !isTransitioning.value || !window2) {
          return;
        }
        window2.transitionHeight.value = convertToUnit(el.clientHeight);
      });
    }
    const transition = computed(() => {
      const name = window2.isReversed.value ? props.reverseTransition : props.transition;
      return !hasTransition.value ? false : {
        name: typeof name !== "string" ? window2.transition.value : name,
        onBeforeEnter: onBeforeTransition,
        onAfterEnter: onAfterTransition,
        onEnterCancelled: onTransitionCancelled,
        onBeforeLeave: onBeforeTransition,
        onAfterLeave: onAfterTransition,
        onLeaveCancelled: onTransitionCancelled,
        onEnter: onEnterTransition
      };
    });
    const {
      hasContent
    } = useLazy(props, groupItem.isSelected);
    useRender(() => createVNode(MaybeTransition, {
      "transition": transition.value,
      "disabled": !isBooted.value
    }, {
      default: () => {
        var _a;
        return [withDirectives(createVNode("div", {
          "class": ["v-window-item", groupItem.selectedClass.value, props.class],
          "style": props.style
        }, [hasContent.value && ((_a = slots.default) == null ? void 0 : _a.call(slots))]), [[vShow, groupItem.isSelected.value]])];
      }
    }));
    return {
      groupItem
    };
  }
});
const _sfc_main = defineComponent({
  name: "index",
  data() {
    return {
      infoTab: null,
      skills: [],
      projects: [],
      clickedProject: void 0,
      clickedSkill: void 0,
      loadProjects: false,
      loadSkills: false
    };
  },
  async mounted() {
    const response = await $fetch("/data.json");
    this.skills = response.skills;
    this.projects = response.projects;
    AOS.init();
    document.addEventListener("aos:in:query-projects", ({ detail }) => {
      setTimeout(() => {
        if (this.infoTab === 1) {
          this.loadProjects = true;
        }
      }, 1500);
    });
    document.addEventListener("aos:in:query-skills", ({ detail }) => {
      setTimeout(() => {
        if (this.infoTab === 2) {
          this.loadSkills = true;
        }
      }, 1500);
    });
  }
});
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_NuxtLayout = __nuxt_component_0;
  const _component_Vprojectcarousel = __nuxt_component_1;
  _push(ssrRenderComponent(_component_NuxtLayout, mergeProps({
    name: "default",
    selectedPage: 1
  }, _attrs), {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<div class="body-header-container"${_scopeId}>`);
        _push2(ssrRenderComponent(VTabs, {
          modelValue: _ctx.infoTab,
          "onUpdate:modelValue": ($event) => _ctx.infoTab = $event,
          "align-tabs": "center"
        }, {
          default: withCtx((_2, _push3, _parent3, _scopeId2) => {
            if (_push3) {
              _push3(ssrRenderComponent(VTab, { value: 1 }, {
                default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                  if (_push4) {
                    _push4(`Projects`);
                  } else {
                    return [
                      createTextVNode("Projects")
                    ];
                  }
                }),
                _: 1
              }, _parent3, _scopeId2));
              _push3(ssrRenderComponent(VTab, { value: 2 }, {
                default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                  if (_push4) {
                    _push4(`Skills`);
                  } else {
                    return [
                      createTextVNode("Skills")
                    ];
                  }
                }),
                _: 1
              }, _parent3, _scopeId2));
            } else {
              return [
                createVNode(VTab, { value: 1 }, {
                  default: withCtx(() => [
                    createTextVNode("Projects")
                  ]),
                  _: 1
                }),
                createVNode(VTab, { value: 2 }, {
                  default: withCtx(() => [
                    createTextVNode("Skills")
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent2, _scopeId));
        _push2(`</div><div class="body-content-container"${_scopeId}>`);
        _push2(ssrRenderComponent(VWindow, {
          modelValue: _ctx.infoTab,
          "onUpdate:modelValue": ($event) => _ctx.infoTab = $event,
          disabled: "",
          class: "fill-parent"
        }, {
          default: withCtx((_2, _push3, _parent3, _scopeId2) => {
            if (_push3) {
              _push3(ssrRenderComponent(VWindowItem, {
                key: 1,
                value: 1,
                class: "fill-parent"
              }, {
                default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                  if (_push4) {
                    _push4(`<div${ssrRenderAttrs({
                      name: "slide",
                      duration: 500,
                      class: "fill-parent"
                    })}>`);
                    if (_ctx.loadProjects) {
                      _push4(`<div class="fill-parent" data-aos="slide-right" data-aos-delay="150" data-aos-duration="500" data-aos-once="true"${_scopeId3}>`);
                      _push4(ssrRenderComponent(_component_Vprojectcarousel, { projects: _ctx.projects }, null, _parent4, _scopeId3));
                      _push4(`</div>`);
                    } else {
                      _push4(`<div data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000" data-aos-once="true" data-aos-id="query-projects" class="slide-obj-container"${_scopeId3}><div class="slide-obj"${_scopeId3}><div class="slide-text-object"${_scopeId3}><h1${_scopeId3}>SELECT * FROM \`Projects\` WHERE User = &#39;Bossslime&#39; ORDER BY \`Date\`</h1></div></div></div>`);
                    }
                    _push4(`</div>`);
                  } else {
                    return [
                      createVNode(TransitionGroup, {
                        name: "slide",
                        duration: 500,
                        tag: "div",
                        class: "fill-parent"
                      }, {
                        default: withCtx(() => [
                          _ctx.loadProjects ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "fill-parent",
                            "data-aos": "slide-right",
                            "data-aos-delay": "150",
                            "data-aos-duration": "500",
                            "data-aos-once": "true"
                          }, [
                            createVNode(_component_Vprojectcarousel, { projects: _ctx.projects }, null, 8, ["projects"])
                          ])) : (openBlock(), createBlock("div", {
                            key: 1,
                            "data-aos": "fade-up",
                            "data-aos-delay": "200",
                            "data-aos-duration": "1000",
                            "data-aos-once": "true",
                            "data-aos-id": "query-projects",
                            class: "slide-obj-container"
                          }, [
                            createVNode("div", { class: "slide-obj" }, [
                              createVNode("div", { class: "slide-text-object" }, [
                                createVNode("h1", null, "SELECT * FROM `Projects` WHERE User = 'Bossslime' ORDER BY `Date`")
                              ])
                            ])
                          ]))
                        ]),
                        _: 1
                      })
                    ];
                  }
                }),
                _: 1
              }, _parent3, _scopeId2));
              _push3(ssrRenderComponent(VWindowItem, {
                key: 2,
                value: 2,
                class: "fill-parent"
              }, {
                default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                  if (_push4) {
                    _push4(`<div${ssrRenderAttrs({
                      name: "slide",
                      duration: 500,
                      class: "fill-parent"
                    })}>`);
                    if (_ctx.loadSkills) {
                      _push4(`<div class="fill-parent" data-aos="slide-right" data-aos-delay="150" data-aos-duration="500" data-aos-once="true"${_scopeId3}><div class="empty-body-container"${_scopeId3}><h1${_scopeId3}>Coming Soon...</h1></div></div>`);
                    } else {
                      _push4(`<div data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000" data-aos-once="true" data-aos-id="query-skills" class="slide-obj-container"${_scopeId3}><div class="slide-obj"${_scopeId3}><div class="slide-text-object"${_scopeId3}><h1${_scopeId3}>SELECT * FROM \`Skills\` WHERE User = &#39;Bossslime&#39;</h1></div></div></div>`);
                    }
                    _push4(`</div>`);
                  } else {
                    return [
                      createVNode(TransitionGroup, {
                        name: "slide",
                        duration: 500,
                        tag: "div",
                        class: "fill-parent"
                      }, {
                        default: withCtx(() => [
                          _ctx.loadSkills ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "fill-parent",
                            "data-aos": "slide-right",
                            "data-aos-delay": "150",
                            "data-aos-duration": "500",
                            "data-aos-once": "true"
                          }, [
                            createVNode("div", { class: "empty-body-container" }, [
                              createVNode("h1", null, "Coming Soon...")
                            ])
                          ])) : (openBlock(), createBlock("div", {
                            key: 1,
                            "data-aos": "fade-up",
                            "data-aos-delay": "200",
                            "data-aos-duration": "1000",
                            "data-aos-once": "true",
                            "data-aos-id": "query-skills",
                            class: "slide-obj-container"
                          }, [
                            createVNode("div", { class: "slide-obj" }, [
                              createVNode("div", { class: "slide-text-object" }, [
                                createVNode("h1", null, "SELECT * FROM `Skills` WHERE User = 'Bossslime'")
                              ])
                            ])
                          ]))
                        ]),
                        _: 1
                      })
                    ];
                  }
                }),
                _: 1
              }, _parent3, _scopeId2));
            } else {
              return [
                (openBlock(), createBlock(VWindowItem, {
                  key: 1,
                  value: 1,
                  class: "fill-parent"
                }, {
                  default: withCtx(() => [
                    createVNode(TransitionGroup, {
                      name: "slide",
                      duration: 500,
                      tag: "div",
                      class: "fill-parent"
                    }, {
                      default: withCtx(() => [
                        _ctx.loadProjects ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "fill-parent",
                          "data-aos": "slide-right",
                          "data-aos-delay": "150",
                          "data-aos-duration": "500",
                          "data-aos-once": "true"
                        }, [
                          createVNode(_component_Vprojectcarousel, { projects: _ctx.projects }, null, 8, ["projects"])
                        ])) : (openBlock(), createBlock("div", {
                          key: 1,
                          "data-aos": "fade-up",
                          "data-aos-delay": "200",
                          "data-aos-duration": "1000",
                          "data-aos-once": "true",
                          "data-aos-id": "query-projects",
                          class: "slide-obj-container"
                        }, [
                          createVNode("div", { class: "slide-obj" }, [
                            createVNode("div", { class: "slide-text-object" }, [
                              createVNode("h1", null, "SELECT * FROM `Projects` WHERE User = 'Bossslime' ORDER BY `Date`")
                            ])
                          ])
                        ]))
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                })),
                (openBlock(), createBlock(VWindowItem, {
                  key: 2,
                  value: 2,
                  class: "fill-parent"
                }, {
                  default: withCtx(() => [
                    createVNode(TransitionGroup, {
                      name: "slide",
                      duration: 500,
                      tag: "div",
                      class: "fill-parent"
                    }, {
                      default: withCtx(() => [
                        _ctx.loadSkills ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "fill-parent",
                          "data-aos": "slide-right",
                          "data-aos-delay": "150",
                          "data-aos-duration": "500",
                          "data-aos-once": "true"
                        }, [
                          createVNode("div", { class: "empty-body-container" }, [
                            createVNode("h1", null, "Coming Soon...")
                          ])
                        ])) : (openBlock(), createBlock("div", {
                          key: 1,
                          "data-aos": "fade-up",
                          "data-aos-delay": "200",
                          "data-aos-duration": "1000",
                          "data-aos-once": "true",
                          "data-aos-id": "query-skills",
                          class: "slide-obj-container"
                        }, [
                          createVNode("div", { class: "slide-obj" }, [
                            createVNode("div", { class: "slide-text-object" }, [
                              createVNode("h1", null, "SELECT * FROM `Skills` WHERE User = 'Bossslime'")
                            ])
                          ])
                        ]))
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                }))
              ];
            }
          }),
          _: 1
        }, _parent2, _scopeId));
        _push2(`</div>`);
      } else {
        return [
          createVNode("div", { class: "body-header-container" }, [
            createVNode(VTabs, {
              modelValue: _ctx.infoTab,
              "onUpdate:modelValue": ($event) => _ctx.infoTab = $event,
              "align-tabs": "center"
            }, {
              default: withCtx(() => [
                createVNode(VTab, { value: 1 }, {
                  default: withCtx(() => [
                    createTextVNode("Projects")
                  ]),
                  _: 1
                }),
                createVNode(VTab, { value: 2 }, {
                  default: withCtx(() => [
                    createTextVNode("Skills")
                  ]),
                  _: 1
                })
              ]),
              _: 1
            }, 8, ["modelValue", "onUpdate:modelValue"])
          ]),
          createVNode("div", { class: "body-content-container" }, [
            createVNode(VWindow, {
              modelValue: _ctx.infoTab,
              "onUpdate:modelValue": ($event) => _ctx.infoTab = $event,
              disabled: "",
              class: "fill-parent"
            }, {
              default: withCtx(() => [
                (openBlock(), createBlock(VWindowItem, {
                  key: 1,
                  value: 1,
                  class: "fill-parent"
                }, {
                  default: withCtx(() => [
                    createVNode(TransitionGroup, {
                      name: "slide",
                      duration: 500,
                      tag: "div",
                      class: "fill-parent"
                    }, {
                      default: withCtx(() => [
                        _ctx.loadProjects ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "fill-parent",
                          "data-aos": "slide-right",
                          "data-aos-delay": "150",
                          "data-aos-duration": "500",
                          "data-aos-once": "true"
                        }, [
                          createVNode(_component_Vprojectcarousel, { projects: _ctx.projects }, null, 8, ["projects"])
                        ])) : (openBlock(), createBlock("div", {
                          key: 1,
                          "data-aos": "fade-up",
                          "data-aos-delay": "200",
                          "data-aos-duration": "1000",
                          "data-aos-once": "true",
                          "data-aos-id": "query-projects",
                          class: "slide-obj-container"
                        }, [
                          createVNode("div", { class: "slide-obj" }, [
                            createVNode("div", { class: "slide-text-object" }, [
                              createVNode("h1", null, "SELECT * FROM `Projects` WHERE User = 'Bossslime' ORDER BY `Date`")
                            ])
                          ])
                        ]))
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                })),
                (openBlock(), createBlock(VWindowItem, {
                  key: 2,
                  value: 2,
                  class: "fill-parent"
                }, {
                  default: withCtx(() => [
                    createVNode(TransitionGroup, {
                      name: "slide",
                      duration: 500,
                      tag: "div",
                      class: "fill-parent"
                    }, {
                      default: withCtx(() => [
                        _ctx.loadSkills ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "fill-parent",
                          "data-aos": "slide-right",
                          "data-aos-delay": "150",
                          "data-aos-duration": "500",
                          "data-aos-once": "true"
                        }, [
                          createVNode("div", { class: "empty-body-container" }, [
                            createVNode("h1", null, "Coming Soon...")
                          ])
                        ])) : (openBlock(), createBlock("div", {
                          key: 1,
                          "data-aos": "fade-up",
                          "data-aos-delay": "200",
                          "data-aos-duration": "1000",
                          "data-aos-once": "true",
                          "data-aos-id": "query-skills",
                          class: "slide-obj-container"
                        }, [
                          createVNode("div", { class: "slide-obj" }, [
                            createVNode("div", { class: "slide-text-object" }, [
                              createVNode("h1", null, "SELECT * FROM `Skills` WHERE User = 'Bossslime'")
                            ])
                          ])
                        ]))
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                }))
              ]),
              _: 1
            }, 8, ["modelValue", "onUpdate:modelValue"])
          ])
        ];
      }
    }),
    _: 1
  }, _parent));
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const index = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);

export { index as default };
//# sourceMappingURL=index-2e729e26.mjs.map
