import { addVitePlugin } from '@nuxt/kit';
import VueInspector from 'vite-plugin-vue-inspector';

async function setup({ nuxt, options }) {
  if (!nuxt.options.dev)
    return;
  addVitePlugin(VueInspector({
    toggleComboKey: "",
    ...typeof options.componentInspector === "boolean" ? {} : options.componentInspector,
    appendTo: /\/entry\.m?js$/,
    toggleButtonVisibility: "never"
  }));
}

export { setup };
