import { TransitionProps, KeepAliveProps } from 'vue';
import { ViteDevServer, UserConfig, ServerOptions } from 'vite';
import { Options as Options$5 } from '@vitejs/plugin-vue';
import { Options as Options$6 } from '@vitejs/plugin-vue-jsx';
import { SchemaDefinition, Schema } from 'untyped';
export { SchemaDefinition } from 'untyped';
import { NitroConfig, Nitro, NitroEventHandler, NitroDevEventHandler, NitroRuntimeConfigApp, NitroRuntimeConfig } from 'nitropack';
import { SnakeCase } from 'scule';
import { Hookable } from 'hookable';
import { Ignore, Options } from 'ignore';
import { Server } from 'node:http';
import { Server as Server$1 } from 'node:https';
import { TSConfig } from 'pkg-types';
import { Manifest } from 'vue-bundle-renderer';
import { EventHandler } from 'h3';
import { InlinePreset, Import, Unimport, UnimportOptions } from 'unimport';
import { Configuration, Compiler, Stats, WebpackError } from 'webpack';
import { RouteLocationRaw, RouterOptions as RouterOptions$1, RouterHistory } from 'vue-router';
import { CompilerOptions } from '@vue/compiler-core';
import { BundleAnalyzerPlugin } from 'webpack-bundle-analyzer';
import { PluginVisualizerOptions } from 'rollup-plugin-visualizer';
import { TransformerOptions } from 'unctx/transform';
import { SourceOptions } from 'c12';
import { NuxtLinkOptions } from '#app/components/nuxt-link';
import { FetchOptions } from 'ofetch';
import { PluginOptions } from 'mini-css-extract-plugin';
import { LoaderOptions } from 'esbuild-loader';
import { Options as Options$1 } from 'file-loader';
import { Options as Options$2 } from 'pug';
import { VueLoaderOptions } from 'vue-loader';
import { Options as Options$3 } from 'sass-loader';
import { BasePluginOptions, DefinedDefaultMinimizerAndOptions } from 'css-minimizer-webpack-plugin';
import { ProcessOptions } from 'postcss';
import { Options as Options$4 } from 'webpack-dev-middleware';
import { IncomingMessage, ServerResponse } from 'http';
import { MiddlewareOptions, ClientOptions } from 'webpack-hot-middleware';
import { MergeHead, Head } from '@unhead/schema';
import * as untyped_dist_types_a304c6a0 from 'untyped/dist/types-a304c6a0';

interface NuxtCompatibility {
    /**
     * Required nuxt version in semver format.
     * @example `^2.14.0` or `>=3.0.0-27219851.6e49637`.
     */
    nuxt?: string;
    /**
     * Bridge constraint for Nuxt 2 support.
     *
     * - `true`:  When using Nuxt 2, using bridge module is required.
     * - `false`: When using Nuxt 2, using bridge module is not supported.
     */
    bridge?: boolean;
}
interface NuxtCompatibilityIssue {
    name: string;
    message: string;
}
interface NuxtCompatibilityIssues extends Array<NuxtCompatibilityIssue> {
    /**
     * Return formatted error message.
     */
    toString(): string;
}

interface Component {
    pascalName: string;
    kebabName: string;
    export: string;
    filePath: string;
    shortPath: string;
    chunkName: string;
    prefetch: boolean;
    preload: boolean;
    global?: boolean | 'sync';
    island?: boolean;
    mode?: 'client' | 'server' | 'all';
    /**
     * This number allows configuring the behavior of overriding Nuxt components.
     * If multiple components are provided with the same name, then higher priority
     * components will be used instead of lower priority components.
     */
    priority?: number;
    /**
     * Allow bypassing client/server transforms for internal Nuxt components like
     * ServerPlaceholder and NuxtClientFallback.
     *
     * @internal
     */
    _raw?: boolean;
}
interface ScanDir {
    /**
     * Path (absolute or relative) to the directory containing your components.
     * You can use Nuxt aliases (~ or @) to refer to directories inside project or directly use an npm package path similar to require.
     */
    path: string;
    /**
     * Accept Pattern that will be run against specified path.
     */
    pattern?: string | string[];
    /**
     * Ignore patterns that will be run against specified path.
     */
    ignore?: string[];
    /**
     * Prefix all matched components.
     */
    prefix?: string;
    /**
     * Prefix component name by its path.
     */
    pathPrefix?: boolean;
    /**
     * Ignore scanning this directory if set to `true`
     */
    enabled?: boolean;
    /**
     * These properties (prefetch/preload) are used in production to configure how components with Lazy prefix are handled by webpack via its magic comments.
     * Learn more on webpack documentation: https://webpack.js.org/api/module-methods/#magic-comments
     */
    prefetch?: boolean;
    /**
     * These properties (prefetch/preload) are used in production to configure how components with Lazy prefix are handled by webpack via its magic comments.
     * Learn more on webpack documentation: https://webpack.js.org/api/module-methods/#magic-comments
     */
    preload?: boolean;
    /**
     * This flag indicates, component should be loaded async (with a separate chunk) regardless of using Lazy prefix or not.
     */
    isAsync?: boolean;
    extendComponent?: (component: Component) => Promise<Component | void> | (Component | void);
    /**
     * If enabled, registers components to be globally available.
     *
     */
    global?: boolean;
    /**
     * If enabled, registers components as islands
     */
    island?: boolean;
}
interface ComponentsDir extends ScanDir {
    /**
     * Watch specified path for changes, including file additions and file deletions.
     */
    watch?: boolean;
    /**
     * Extensions supported by Nuxt builder.
     */
    extensions?: string[];
    /**
     * Transpile specified path using build.transpile.
     * By default ('auto') it will set transpile: true if node_modules/ is in path.
     */
    transpile?: 'auto' | boolean;
    /**
     * This number allows configuring the behavior of overriding Nuxt components.
     * It will be inherited by any components within the directory.
     *
     * If multiple components are provided with the same name, then higher priority
     * components will be used instead of lower priority components.
     */
    priority?: number;
}
interface ComponentsOptions {
    dirs: (string | ComponentsDir)[];
    /**
     * The default value for whether to globally register components.
     *
     * When components are registered globally, they will still be directly imported where used,
     * but they can also be used dynamically, for example `<component :is="`icon-${myIcon}`">`.
     *
     * This can be overridden by an individual component directory entry.
     * @default false
     */
    global?: boolean;
    loader?: boolean;
    transform?: {
        exclude?: RegExp[];
        include?: RegExp[];
    };
}

type HookResult = Promise<void> | void;
type TSReference = {
    types: string;
} | {
    path: string;
};
type WatchEvent = 'add' | 'addDir' | 'change' | 'unlink' | 'unlinkDir';
type NuxtPage = {
    name?: string;
    path: string;
    file?: string;
    meta?: Record<string, any>;
    alias?: string[] | string;
    redirect?: RouteLocationRaw;
    children?: NuxtPage[];
};
type NuxtMiddleware = {
    name: string;
    path: string;
    global?: boolean;
};
type NuxtLayout = {
    name: string;
    file: string;
};
interface ImportPresetWithDeprecation extends InlinePreset {
}
interface GenerateAppOptions {
    filter?: (template: ResolvedNuxtTemplate<any>) => boolean;
}
interface NuxtAnalyzeMeta {
    name: string;
    slug: string;
    startTime: number;
    endTime: number;
    analyzeDir: string;
    buildDir: string;
    outDir: string;
}
/**
 * The listeners to Nuxt build time events
 */
interface NuxtHooks {
    /**
     * Allows extending compatibility checks.
     * @param compatibility Compatibility object
     * @param issues Issues to be mapped
     * @returns Promise
     */
    'kit:compatibility': (compatibility: NuxtCompatibility, issues: NuxtCompatibilityIssues) => HookResult;
    /**
     * Called after Nuxt initialization, when the Nuxt instance is ready to work.
     * @param nuxt The configured Nuxt object
     * @returns Promise
     */
    'ready': (nuxt: Nuxt) => HookResult;
    /**
     * Called when Nuxt instance is gracefully closing.
     * @param nuxt The configured Nuxt object
     * @returns Promise
     */
    'close': (nuxt: Nuxt) => HookResult;
    /**
     * Called to restart the current Nuxt instance.
     * @returns Promise
     */
    'restart': (options?: {
        /**
         * Try to restart the whole process if supported
         */
        hard?: boolean;
    }) => HookResult;
    /**
     * Called during Nuxt initialization, before installing user modules.
     * @returns Promise
     */
    'modules:before': () => HookResult;
    /**
     * Called during Nuxt initialization, after installing user modules.
     * @returns Promise
     */
    'modules:done': () => HookResult;
    /**
     * Called after resolving the `app` instance.
     * @param app The resolved `NuxtApp` object
     * @returns Promise
     */
    'app:resolve': (app: NuxtApp) => HookResult;
    /**
     * Called during `NuxtApp` generation, to allow customizing, modifying or adding new files to the build directory (either virtually or to written to `.nuxt`).
     * @param app The configured `NuxtApp` object
     * @returns Promise
     */
    'app:templates': (app: NuxtApp) => HookResult;
    /**
     * Called after templates are compiled into the [virtual file system](https://nuxt.com/docs/guide/directory-structure/nuxt#virtual-file-system) (vfs).
     * @param app The configured `NuxtApp` object
     * @returns Promise
     */
    'app:templatesGenerated': (app: NuxtApp, templates: ResolvedNuxtTemplate[], options?: GenerateAppOptions) => HookResult;
    /**
     * Called before Nuxt bundle builder.
     * @returns Promise
     */
    'build:before': () => HookResult;
    /**
     * Called after Nuxt bundle builder is complete.
     * @returns Promise
     */
    'build:done': () => HookResult;
    /**
     * Called during the manifest build by Vite and Webpack. This allows customizing the manifest that Nitro will use to render `<script>` and `<link>` tags in the final HTML.
     * @param manifest The manifest object to build
     * @returns Promise
     */
    'build:manifest': (manifest: Manifest) => HookResult;
    /**
     * Called when `nuxt analyze` is finished
     * @param meta the analyze meta object, mutations will be saved to `meta.json`
     * @returns Promise
     */
    'build:analyze:done': (meta: NuxtAnalyzeMeta) => HookResult;
    /**
     * Called before generating the app.
     * @param options GenerateAppOptions object
     * @returns Promise
     */
    'builder:generateApp': (options?: GenerateAppOptions) => HookResult;
    /**
     * Called at build time in development when the watcher spots a change to a file or directory in the project.
     * @param event "add" | "addDir" | "change" | "unlink" | "unlinkDir"
     * @param path the path to the watched file
     * @returns Promise
     */
    'builder:watch': (event: WatchEvent, path: string) => HookResult;
    /**
     * Called after pages routes are resolved.
     * @param pages Array containing resolved pages
     * @returns Promise
     */
    'pages:extend': (pages: NuxtPage[]) => HookResult;
    /**
     * Called when the dev middleware is being registered on the Nitro dev server.
     * @param handler the Vite or Webpack event handler
     * @returns Promise
     */
    'server:devHandler': (handler: EventHandler) => HookResult;
    /**
     * Called at setup allowing modules to extend sources.
     * @param presets Array containing presets objects
     * @returns Promise
     */
    'imports:sources': (presets: ImportPresetWithDeprecation[]) => HookResult;
    /**
     * Called at setup allowing modules to extend imports.
     * @param imports Array containing the imports to extend
     * @returns Promise
     */
    'imports:extend': (imports: Import[]) => HookResult;
    /**
     * Called when the [unimport](https://github.com/unjs/unimport) context is created.
     * @param context The Unimport context
     * @returns Promise
     */
    'imports:context': (context: Unimport) => HookResult;
    /**
     * Allows extending import directories.
     * @param dirs Array containing directories as string
     * @returns Promise
     */
    'imports:dirs': (dirs: string[]) => HookResult;
    /**
     * Called within `app:resolve` allowing to extend the directories that are scanned for auto-importable components.
     * @param dirs The `dirs` option to push new items
     * @returns Promise
     */
    'components:dirs': (dirs: ComponentsOptions['dirs']) => HookResult;
    /**
     * Allows extending new components.
     * @param components The `components` array to push new items
     * @returns Promise
     */
    'components:extend': (components: Component[]) => HookResult;
    /**
     * Called before initializing Nitro, allowing customization of Nitro's configuration.
     * @param nitroConfig The nitro config to be extended
     * @returns Promise
     */
    'nitro:config': (nitroConfig: NitroConfig) => HookResult;
    /**
     * Called after Nitro is initialized, which allows registering Nitro hooks and interacting directly with Nitro.
     * @param nitro The created nitro object
     * @returns Promise
     */
    'nitro:init': (nitro: Nitro) => HookResult;
    /**
     * Called before building the Nitro instance.
     * @param nitro The created nitro object
     * @returns Promise
     */
    'nitro:build:before': (nitro: Nitro) => HookResult;
    /**
     * Called after copying public assets. Allows modifying public assets before Nitro server is built.
     * @param nitro The created nitro object
     * @returns Promise
     */
    'nitro:build:public-assets': (nitro: Nitro) => HookResult;
    /**
     * Allows extending the routes to be pre-rendered.
     * @param ctx Nuxt context
     * @returns Promise
     */
    'prerender:routes': (ctx: {
        routes: Set<string>;
    }) => HookResult;
    /**
     * Called when an error occurs at build time.
     * @param error Error object
     * @returns Promise
     */
    'build:error': (error: Error) => HookResult;
    /**
     * Called before Nuxi writes `.nuxt/tsconfig.json` and `.nuxt/nuxt.d.ts`, allowing addition of custom references and declarations in `nuxt.d.ts`, or directly modifying the options in `tsconfig.json`
     * @param options Objects containing `references`, `declarations`, `tsConfig`
     * @returns Promise
     */
    'prepare:types': (options: {
        references: TSReference[];
        declarations: string[];
        tsConfig: TSConfig;
    }) => HookResult;
    /**
     * Called when the dev server is loading.
     * @param listenerServer The HTTP/HTTPS server object
     * @param listener The server's listener object
     * @returns Promise
     */
    'listen': (listenerServer: Server | Server$1, listener: any) => HookResult;
    /**
     * Allows extending default schemas.
     * @param schemas Schemas to be extend
     * @returns void
     */
    'schema:extend': (schemas: SchemaDefinition[]) => void;
    /**
     * Allows extending resolved schema.
     * @param schema Schema object
     * @returns void
     */
    'schema:resolved': (schema: Schema) => void;
    /**
     * Called before writing the given schema.
     * @param schema Schema object
     * @returns void
     */
    'schema:beforeWrite': (schema: Schema) => void;
    /**
     * Called after the schema is written.
     * @returns void
     */
    'schema:written': () => void;
    /**
     * Allows to extend Vite default context.
     * @param viteBuildContext The vite build context object
     * @returns Promise
     */
    'vite:extend': (viteBuildContext: {
        nuxt: Nuxt;
        config: ViteConfig;
    }) => HookResult;
    /**
     * Allows to extend Vite default config.
     * @param viteInlineConfig The vite inline config object
     * @param env Server or client
     * @returns Promise
     */
    'vite:extendConfig': (viteInlineConfig: ViteConfig, env: {
        isClient: boolean;
        isServer: boolean;
    }) => HookResult;
    /**
     * Allows to read the resolved Vite config.
     * @param viteInlineConfig The vite inline config object
     * @param env Server or client
     * @returns Promise
     */
    'vite:configResolved': (viteInlineConfig: Readonly<ViteConfig>, env: {
        isClient: boolean;
        isServer: boolean;
    }) => HookResult;
    /**
     * Called when the Vite server is created.
     * @param viteServer Vite development server
     * @param env Server or client
     * @returns Promise
     */
    'vite:serverCreated': (viteServer: ViteDevServer, env: {
        isClient: boolean;
        isServer: boolean;
    }) => HookResult;
    /**
     * Called after Vite server is compiled.
     * @returns Promise
     */
    'vite:compiled': () => HookResult;
    /**
     * Called before configuring the webpack compiler.
     * @param webpackConfigs Configs objects to be pushed to the compiler
     * @returns Promise
     */
    'webpack:config': (webpackConfigs: Configuration[]) => HookResult;
    /**
     * Allows to read the resolved webpack config
     * @param webpackConfigs Configs objects to be pushed to the compiler
     * @returns Promise
     */
    'webpack:configResolved': (webpackConfigs: Readonly<Configuration>[]) => HookResult;
    /**
     * Called right before compilation.
     * @param options The options to be added
     * @returns Promise
     */
    'webpack:compile': (options: {
        name: string;
        compiler: Compiler;
    }) => HookResult;
    /**
     * Called after resources are loaded.
     * @param options The compiler options
     * @returns Promise
     */
    'webpack:compiled': (options: {
        name: string;
        compiler: Compiler;
        stats: Stats;
    }) => HookResult;
    /**
     * Called on `change` on WebpackBar.
     * @param shortPath the short path
     * @returns void
     */
    'webpack:change': (shortPath: string) => void;
    /**
     * Called on `done` if has errors on WebpackBar.
     * @returns void
     */
    'webpack:error': () => void;
    /**
     * Called on `allDone` on WebpackBar.
     * @returns void
     */
    'webpack:done': () => void;
    /**
     * Called on `progress` on WebpackBar.
     * @param statesArray The array containing the states on progress
     * @returns void
     */
    'webpack:progress': (statesArray: any[]) => void;
}
type NuxtHookName = keyof NuxtHooks;

interface NuxtPlugin {
    /** @deprecated use mode */
    ssr?: boolean;
    src: string;
    mode?: 'all' | 'server' | 'client';
    /**
     * This allows more granular control over plugin order and should only be used by advanced users.
     * Lower numbers run first, and user plugins default to `0`.
     *
     * Default Nuxt priorities can be seen at [here](https://github.com/nuxt/nuxt/blob/9904849bc87c53dfbd3ea3528140a5684c63c8d8/packages/nuxt/src/core/plugins/plugin-metadata.ts#L15-L34).
     */
    order?: number;
}
type TemplateDefaultOptions = Record<string, any>;
interface NuxtTemplate<Options = TemplateDefaultOptions> {
    /** resolved output file path (generated) */
    dst?: string;
    /** The target filename once the template is copied into the Nuxt buildDir */
    filename?: string;
    /** An options object that will be accessible within the template via `<% options %>` */
    options?: Options;
    /** The resolved path to the source file to be template */
    src?: string;
    /** Provided compile option instead of src */
    getContents?: (data: Options) => string | Promise<string>;
    /** Write to filesystem */
    write?: boolean;
}
interface ResolvedNuxtTemplate<Options = TemplateDefaultOptions> extends NuxtTemplate<Options> {
    filename: string;
    dst: string;
}
interface NuxtTypeTemplate<Options = TemplateDefaultOptions> extends Omit<NuxtTemplate<Options>, 'write'> {
    write?: true;
}
type _TemplatePlugin<Options> = Omit<NuxtPlugin, 'src'> & NuxtTemplate<Options>;
interface NuxtPluginTemplate<Options = TemplateDefaultOptions> extends _TemplatePlugin<Options> {
}
interface NuxtApp {
    mainComponent?: string | null;
    rootComponent?: string | null;
    errorComponent?: string | null;
    dir: string;
    extensions: string[];
    plugins: NuxtPlugin[];
    components: Component[];
    layouts: Record<string, NuxtLayout>;
    middleware: NuxtMiddleware[];
    templates: NuxtTemplate[];
    configs: string[];
    pages?: NuxtPage[];
}
interface Nuxt {
    _version: string;
    _ignore?: Ignore;
    _ignorePatterns?: string[];
    /** The resolved Nuxt configuration. */
    options: NuxtOptions;
    hooks: Hookable<NuxtHooks>;
    hook: Nuxt['hooks']['hook'];
    callHook: Nuxt['hooks']['callHook'];
    addHooks: Nuxt['hooks']['addHooks'];
    ready: () => Promise<void>;
    close: () => Promise<void>;
    /** The production or development server. */
    server?: any;
    vfs: Record<string, string>;
    apps: Record<string, NuxtApp>;
}

interface ImportsOptions extends UnimportOptions {
    /**
     * Enable implicit auto import from Vue, Nuxt and module contributed utilities.
     * Generate global TypeScript definitions.
     * @default true
     */
    autoImport?: boolean;
    /**
     * Directories to scan for auto imports.
     * @see https://nuxt.com/docs/guide/directory-structure/composables#how-files-are-scanned
     * @default ['./composables', './utils']
     */
    dirs?: string[];
    /**
     * Assign auto imported utilities to `globalThis` instead of using built time transformation.
     * @default false
     */
    global?: boolean;
    transform?: {
        exclude?: RegExp[];
        include?: RegExp[];
    };
}

interface ModuleMeta {
    /** Module name. */
    name?: string;
    /** Module version. */
    version?: string;
    /**
     * The configuration key used within `nuxt.config` for this module's options.
     * For example, `@nuxtjs/axios` uses `axios`.
     */
    configKey?: string;
    /**
     * Constraints for the versions of Nuxt or features this module requires.
     */
    compatibility?: NuxtCompatibility;
    [key: string]: unknown;
}
/** The options received.  */
type ModuleOptions = Record<string, any>;
/** Optional result for nuxt modules */
interface ModuleSetupReturn {
    /**
     * Timing information for the initial setup
     */
    timings?: {
        /** Total time took for module setup in ms */
        setup?: number;
        [key: string]: number | undefined;
    };
}
type Awaitable<T> = T | Promise<T>;
type _ModuleSetupReturn = Awaitable<void | false | ModuleSetupReturn>;
/** Input module passed to defineNuxtModule. */
interface ModuleDefinition<T extends ModuleOptions = ModuleOptions> {
    meta?: ModuleMeta;
    defaults?: T | ((nuxt: Nuxt) => T);
    schema?: T;
    hooks?: Partial<NuxtHooks>;
    setup?: (this: void, resolvedOptions: T, nuxt: Nuxt) => _ModuleSetupReturn;
}
interface NuxtModule<T extends ModuleOptions = ModuleOptions> {
    (this: void, inlineOptions: T, nuxt: Nuxt): _ModuleSetupReturn;
    getOptions?: (inlineOptions?: T, nuxt?: Nuxt) => Promise<T>;
    getMeta?: () => Promise<ModuleMeta>;
}

type RouterOptions = Partial<Omit<RouterOptions$1, 'history' | 'routes'>> & {
    history?: (baseURL?: string) => RouterHistory;
    routes?: (_routes: RouterOptions$1['routes']) => RouterOptions$1['routes'];
    hashMode?: boolean;
    scrollBehaviorType?: 'smooth' | 'auto';
};
type RouterConfig = RouterOptions;
/**
 * Only JSON serializable router options are configurable from nuxt config
 */
type RouterConfigSerializable = Pick<RouterConfig, 'linkActiveClass' | 'linkExactActiveClass' | 'end' | 'sensitive' | 'strict' | 'hashMode' | 'scrollBehaviorType'>;

interface ConfigSchema {
 components: boolean | ComponentsOptions | ComponentsOptions['dirs'],

 imports: ImportsOptions,

 pages: boolean,

 telemetry: boolean | Record<string, any>,

 devtools:  { enabled: boolean, [key: string]: any } ,

 vue: {
  compilerOptions: CompilerOptions,

  /** @default false */
  runtimeCompiler: boolean,

  /** @default false */
  propsDestructure: boolean,

  /** @default false */
  defineModel: boolean,
 },

 app: {
  /** @default "/" */
  baseURL: string,

  /** @default "/_nuxt/" */
  buildAssetsDir: string,

  /** @default "" */
  cdnURL: string,

  head: NuxtAppConfig['head'],

  /** @default false */
  layoutTransition: NuxtAppConfig['layoutTransition'],

  /** @default false */
  pageTransition: NuxtAppConfig['pageTransition'],

  /** @default false */
  keepalive: NuxtAppConfig['keepalive'],

  /** @default "__nuxt" */
  rootId: string | false,

  /** @default "div" */
  rootTag: string,
 },

 spaLoadingTemplate: string | boolean,

 plugins: (NuxtPlugin | string)[],

 css: string[],

 /** @default "@nuxt/vite-builder" */
 builder: 'vite' | 'webpack' | { bundle: (nuxt: Nuxt) => Promise<void> },

 sourcemap: boolean | { server?: boolean | 'hidden', client?: boolean | 'hidden' },

 /** @default "info" */
 logLevel: 'silent' | 'info' | 'verbose',

 build: {
  transpile: Array<string | RegExp | ((ctx: { isClient?: boolean; isServer?: boolean; isDev: boolean }) => string | RegExp | false)>,

  templates: NuxtTemplate<any>[],

  analyze: boolean | { enabled?: boolean } & ((0 extends 1 & BundleAnalyzerPlugin.Options ? {} : BundleAnalyzerPlugin.Options) | PluginVisualizerOptions),
 },

 optimization: {
  /** @default [{"name":"defineNuxtComponent","argumentLength":2},{"name":"useState","argumentLength":2},{"name":"useFetch","argumentLength":3},{"name":"useAsyncData","argumentLength":3},{"name":"useLazyAsyncData","argumentLength":3},{"name":"useLazyFetch","argumentLength":3}] */
  keyedComposables: Array<{ name: string, source?: string | RegExp, argumentLength: number }>,

  treeShake: {
   composables: {
    server: {
     [key: string]: any
    },

    client: {
     [key: string]: any
    },
   },
  },

  asyncTransforms: TransformerOptions,
 },

 extends: string | [string, SourceOptions?] | (string | [string, SourceOptions?])[],

 /** @default null */
 theme: string,

 /** @default "/<rootDir>" */
 rootDir: string,

 /** @default "/<rootDir>" */
 workspaceDir: string,

 /** @default "/<rootDir>" */
 srcDir: string,

 /** @default "/<rootDir>/server" */
 serverDir: string,

 /** @default "/<rootDir>/.nuxt" */
 buildDir: string,

 /** @default ["/<rootDir>/node_modules","/Users/daniel/code/nuxt.js/packages/schema/node_modules"] */
 modulesDir: Array<string>,

 /** @default "/<rootDir>/.nuxt/analyze" */
 analyzeDir: string,

 /** @default false */
 dev: boolean,

 /** @default false */
 test: boolean,

 /** @default false */
 debug: boolean,

 /** @default true */
 ssr: boolean,

 modules: (NuxtModule | string | [NuxtModule | string, Record<string, any>] | undefined | null | false)[],

 dir: {
  /** @default "assets" */
  assets: string,

  /** @default "layouts" */
  layouts: string,

  /** @default "middleware" */
  middleware: string,

  /** @default "modules" */
  modules: string,

  /** @default "pages" */
  pages: string,

  /** @default "plugins" */
  plugins: string,

  /** @default "public" */
  public: string,

  /**
   * @default "public"
   * 
   * @deprecated use `dir.public` option instead
  */
  static: string,
 },

 /** @default [".js",".jsx",".mjs",".ts",".tsx",".vue"] */
 extensions: Array<string>,

 alias: Record<string, string>,

 ignoreOptions: Options,

 /** @default "-" */
 ignorePrefix: string,

 /** @default ["**\/*.stories.{js,cts,mts,ts,jsx,tsx}","**\/*.{spec,test}.{js,cts,mts,ts,jsx,tsx}","**\/*.d.{cts,mts,ts}","**\/.{pnpm-store,vercel,netlify,output,git,cache,data}",".nuxt/analyze",".nuxt","**\/-*.*"] */
 ignore: Array<string>,

 watch: Array<string | RegExp>,

 watchers: {
  rewatchOnRawEvents: any,

  webpack: {
   /** @default 1000 */
   aggregateTimeout: number,
  },

  chokidar: {
   /** @default true */
   ignoreInitial: boolean,
  },
 },

 hooks: NuxtHooks,

 runtimeConfig: RuntimeConfig,

 appConfig: AppConfig,

 devServer: {
  /** @default false */
  https: boolean | { key: string; cert: string },

  /** @default 3000 */
  port: number,

  host: any,

  /** @default "http://localhost:3000" */
  url: string,

  loadingTemplate: (data: { loading?: string }) => string,
 },

 experimental: {
  /** @default false */
  asyncEntry: boolean,

  /** @default false */
  reactivityTransform: boolean,

  /** @default true */
  externalVue: boolean,

  /** @default true */
  treeshakeClientOnly: boolean,

  /** @default "automatic" */
  emitRouteChunkError: false | 'manual' | 'automatic',

  /** @default true */
  templateRouteInjection: boolean,

  /** @default false */
  restoreState: boolean,

  /** @default true */
  inlineSSRStyles: boolean | ((id?: string) => boolean),

  /** @default false */
  noScripts: boolean,

  /** @default true */
  renderJsonPayloads: boolean,

  /** @default false */
  noVueServer: boolean,

  /** @default true */
  payloadExtraction: boolean | undefined,

  /** @default false */
  clientFallback: boolean,

  /** @default false */
  crossOriginPrefetch: boolean,

  /** @default false */
  viewTransition: boolean,

  /** @default false */
  writeEarlyHints: boolean,

  /** @default false */
  componentIslands: true | 'local' | 'local+remote' | false,

  /** @default true */
  configSchema: boolean,

  /** @default false */
  typescriptBundlerResolution: boolean,

  /** @default false */
  polyfillVueUseHead: boolean,

  /** @default false */
  respectNoSSRHeader: boolean,

  /** @default true */
  localLayerAliases: boolean,

  /** @default false */
  typedPages: boolean,

  /** @default true */
  appManifest: boolean,

  /** @default "chokidar-granular" */
  watcher: 'chokidar' | 'parcel' | 'chokidar-granular',

  /** @default false */
  asyncContext: boolean,

  /** @default false */
  headNext: boolean,

  /** @default false */
  inlineRouteRules: boolean,

  defaults: {
   nuxtLink: NuxtLinkOptions,

   useAsyncData: {
    /** @default true */
    deep: boolean,
   },

   useFetch: Pick<FetchOptions, 'timeout' | 'retry' | 'retryDelay' | 'retryStatusCodes'>,
  },
 },

 generate: {
  routes: string | string[],

  exclude: Array<any>,
 },

 /** @default 3 */
 _majorVersion: number,

 /** @default false */
 _legacyGenerate: boolean,

 /** @default false */
 _start: boolean,

 /** @default false */
 _build: boolean,

 /** @default false */
 _generate: boolean,

 /** @default false */
 _prepare: boolean,

 /** @default false */
 _cli: boolean,

 _requiredModules: any,

 _nuxtConfigFile: any,

 _nuxtConfigFiles: Array<any>,

 /** @default "" */
 appDir: string,

 _installedModules: Array<any>,

 _modules: Array<any>,

 nitro: NitroConfig,

 routeRules: NitroConfig['routeRules'],

 serverHandlers: NitroEventHandler[],

 devServerHandlers: NitroDevEventHandler[],

 postcss: {
  plugins: Record<string, any> & { autoprefixer?: any; cssnano?: any },
 },

 router: {
  options: RouterConfigSerializable,
 },

 typescript: {
  /** @default true */
  strict: boolean,

  builder: 'vite' | 'webpack' | 'shared' | false | undefined,

  /** @default false */
  includeWorkspace: boolean,

  /** @default false */
  typeCheck: boolean | 'build',

  tsConfig: TSConfig,

  /** @default true */
  shim: boolean,
 },

 vite: ViteConfig & { $client?: ViteConfig, $server?: ViteConfig },

 webpack: {
  analyze: boolean | { enabled?: boolean } & BundleAnalyzerPlugin.Options,

  /** @default false */
  profile: boolean,

  /** @default true */
  extractCSS: boolean | PluginOptions,

  /** @default false */
  cssSourceMap: boolean,

  /** @default "url" */
  serverURLPolyfill: string,

  filenames: 
   Record<
     string,
     string |
     ((
       ctx: {
         nuxt: Nuxt,
         options: Nuxt['options'],
         name: string,
         isDev: boolean,
         isServer: boolean,
         isClient: boolean,
         alias: { [index: string]: string | false | string[] },
         transpile: RegExp[]
       }) => string)
   >
  ,

  loaders: {
   esbuild: Omit<LoaderOptions, 'loader'>,

   file: Omit<Options$1, 'name'>,

   fontUrl: Omit<Options$1, 'name'>,

   imgUrl: Omit<Options$1, 'name'>,

   pugPlain: Options$2,

   vue: Partial<VueLoaderOptions>,

   css: {
    /** @default 0 */
    importLoaders: number,

    url: {
     filter: () => any,
    },

    /** @default false */
    esModule: boolean,
   },

   cssModules: {
    /** @default 0 */
    importLoaders: number,

    url: {
     filter: () => any,
    },

    /** @default false */
    esModule: boolean,

    modules: {
     /** @default "[local]_[hash:base64:5]" */
     localIdentName: string,
    },
   },

   less: any,

   sass: Options$3,

   scss: Options$3,

   stylus: any,

   vueStyle: any,
  },

  plugins: Array<any>,

  /** @default false */
  aggressiveCodeRemoval: boolean,

  /** @default false */
  optimizeCSS: false | BasePluginOptions & DefinedDefaultMinimizerAndOptions<any>,

  optimization: false | Configuration['optimization'],

  postcss: { execute?: boolean, postcssOptions: ProcessOptions, sourceMap?: boolean, implementation?: any },

  devMiddleware: Options$4<IncomingMessage, ServerResponse>,

  hotMiddleware: MiddlewareOptions & { client?: ClientOptions },

  /** @default true */
  friendlyErrors: boolean,

  warningIgnoreFilters: Array<(warn: WebpackError) => boolean>,

  experiments: false | Configuration['experiments'],
 },
}

/** @deprecated Extend types from `@unhead/schema` directly. This may be removed in a future minor version. */
interface HeadAugmentations extends MergeHead {
    base?: {};
    link?: {};
    meta?: {};
    style?: {};
    script?: {};
    noscript?: {};
    htmlAttrs?: {};
    bodyAttrs?: {};
}
type MetaObjectRaw = Head<HeadAugmentations>;
type MetaObject = MetaObjectRaw;
type AppHeadMetaObject = MetaObjectRaw & {
    /**
     * The character encoding in which the document is encoded => `<meta charset="<value>" />`
     * @default `'utf-8'`
     */
    charset?: string;
    /**
     * Configuration of the viewport (the area of the window in which web content can be seen),
     * mapped to => `<meta name="viewport" content="<value>" />`
     * @default `'width=device-width, initial-scale=1'`
     */
    viewport?: string;
};

type DeepPartial<T> = T extends Function ? T : T extends Record<string, any> ? {
    [P in keyof T]?: DeepPartial<T[P]>;
} : T;
type UpperSnakeCase<S extends string> = Uppercase<SnakeCase<S>>;
declare const message: unique symbol;
type RuntimeValue<T, B extends string> = T & {
    [message]?: B;
};
type Overrideable<T extends Record<string, any>, Path extends string = ''> = {
    [K in keyof T]?: K extends string ? unknown extends T[K] ? unknown : T[K] extends Record<string, unknown> ? RuntimeValue<Overrideable<T[K], `${Path}_${UpperSnakeCase<K>}`>, `You can override this value at runtime with NUXT${Path}_${UpperSnakeCase<K>}`> : RuntimeValue<T[K], `You can override this value at runtime with NUXT${Path}_${UpperSnakeCase<K>}`> : K extends number ? T[K] : never;
};
type RuntimeConfigNamespace = Record<string, unknown>;
interface PublicRuntimeConfig extends RuntimeConfigNamespace {
}
interface RuntimeConfig extends RuntimeConfigNamespace {
    app: NitroRuntimeConfigApp;
    /** Only available on the server. */
    nitro?: NitroRuntimeConfig['nitro'];
    public: PublicRuntimeConfig;
}
interface NuxtConfig extends DeepPartial<Omit<ConfigSchema, 'vite' | 'runtimeConfig'>> {
    vite?: ConfigSchema['vite'];
    runtimeConfig?: Overrideable<RuntimeConfig>;
    webpack?: DeepPartial<ConfigSchema['webpack']> & {
        $client?: DeepPartial<ConfigSchema['webpack']>;
        $server?: DeepPartial<ConfigSchema['webpack']>;
    };
    /**
     * Experimental custom config schema
     * @see [Nuxt Issue #15592](https://github.com/nuxt/nuxt/issues/15592)
     */
    $schema?: SchemaDefinition;
}
interface ConfigLayer<T> {
    config: T;
    cwd: string;
    configFile: string;
}
type NuxtConfigLayer = ConfigLayer<NuxtConfig & {
    srcDir: ConfigSchema['srcDir'];
    rootDir: ConfigSchema['rootDir'];
}>;
interface NuxtBuilder {
    bundle: (nuxt: Nuxt) => Promise<void>;
}
interface NuxtOptions extends Omit<ConfigSchema, 'builder' | 'webpack'> {
    sourcemap: Required<Exclude<ConfigSchema['sourcemap'], boolean>>;
    builder: '@nuxt/vite-builder' | '@nuxt/webpack-builder' | NuxtBuilder;
    webpack: ConfigSchema['webpack'] & {
        $client: ConfigSchema['webpack'];
        $server: ConfigSchema['webpack'];
    };
    _layers: NuxtConfigLayer[];
    $schema: SchemaDefinition;
}
interface ViteConfig extends Omit<UserConfig, 'publicDir'> {
    /** The path to the entrypoint for the Vite build. */
    entry?: string;
    /**
     * Options passed to @vitejs/plugin-vue.
     * @see [@vitejs/plugin-vue](https://github.com/vitejs/vite-plugin-vue/tree/main/packages/plugin-vue)
     */
    vue?: Options$5;
    /**
     * Options passed to @vitejs/plugin-vue-jsx.
     * @see [@vitejs/plugin-vue-jsx.](https://github.com/vitejs/vite-plugin-vue/tree/main/packages/plugin-vue-jsx)
     */
    vueJsx?: Options$6;
    /**
     * Bundler for dev time server-side rendering.
     * @default 'vite-node'
     */
    devBundler?: 'vite-node' | 'legacy';
    /**
     * Warmup vite entrypoint caches on dev startup.
     */
    warmupEntry?: boolean;
    /**
     * Use environment variables or top level `server` options to configure Nuxt server.
     */
    server?: Omit<ServerOptions, 'port' | 'host'>;
    /**
     * Directly configuring the `vite.publicDir` option is not supported. Instead, set `dir.public`.
     *
     * You can read more in <https://nuxt.com/docs/api/nuxt-config#public>.
     * @deprecated
     */
    publicDir?: never;
}
interface CustomAppConfig {
    [key: string]: unknown;
}
interface AppConfigInput extends CustomAppConfig {
    /** @deprecated reserved */
    private?: never;
    /** @deprecated reserved */
    nuxt?: never;
    /** @deprecated reserved */
    nitro?: never;
    /** @deprecated reserved */
    server?: never;
}
interface NuxtAppConfig {
    head: AppHeadMetaObject;
    layoutTransition: boolean | TransitionProps;
    pageTransition: boolean | TransitionProps;
    keepalive: boolean | KeepAliveProps;
}
interface AppConfig {
    [key: string]: unknown;
}

declare const _default: {
    [x: string]: untyped_dist_types_a304c6a0.J | untyped_dist_types_a304c6a0.I;
};

export { type AppConfig, type AppConfigInput, type AppHeadMetaObject, type Component, type ComponentsDir, type ComponentsOptions, type CustomAppConfig, type GenerateAppOptions, type HeadAugmentations, type HookResult, type ImportPresetWithDeprecation, type ImportsOptions, type MetaObject, type MetaObjectRaw, type ModuleDefinition, type ModuleMeta, type ModuleOptions, type ModuleSetupReturn, type Nuxt, type NuxtAnalyzeMeta, type NuxtApp, type NuxtAppConfig, type NuxtBuilder, type NuxtCompatibility, type NuxtCompatibilityIssue, type NuxtCompatibilityIssues, type NuxtConfig, type NuxtConfigLayer, _default as NuxtConfigSchema, type NuxtHookName, type NuxtHooks, type NuxtLayout, type NuxtMiddleware, type NuxtModule, type NuxtOptions, type NuxtPage, type NuxtPlugin, type NuxtPluginTemplate, type NuxtTemplate, type NuxtTypeTemplate, type PublicRuntimeConfig, type ResolvedNuxtTemplate, type RouterConfig, type RouterConfigSerializable, type RouterOptions, type RuntimeConfig, type RuntimeValue, type ScanDir, type TSReference, type UpperSnakeCase, type ViteConfig, type WatchEvent };
