import type { ComponentsOptions } from '../src/types/components'
import type { ImportsOptions } from '../src/types/imports'
import type { CompilerOptions } from '@vue/compiler-core'
import type { NuxtAppConfig, RuntimeConfig, AppConfig, ViteConfig } from '../src/types/config'
import type { NuxtPlugin, Nuxt, NuxtTemplate } from '../src/types/nuxt'
import type { BundleAnalyzerPlugin } from 'webpack-bundle-analyzer'
import type { PluginVisualizerOptions } from 'rollup-plugin-visualizer'
import type { TransformerOptions } from 'unctx/transform'
import type { SourceOptions } from 'c12'
import type { NuxtModule } from '../src/types/module'
import type { Options } from 'ignore'
import type { NuxtHooks } from '../src/types/hooks'
import type { NuxtLinkOptions } from '#app/components/nuxt-link'
import type { FetchOptions } from 'ofetch'
import type { NitroConfig, NitroEventHandler, NitroDevEventHandler } from 'nitropack'
import type { RouterConfigSerializable } from '../src/types/router'
import type { TSConfig } from 'pkg-types'
import type { PluginOptions } from 'mini-css-extract-plugin'
import type { LoaderOptions } from 'esbuild-loader'
import type { Options as Options0 } from 'file-loader'
import type { Options as Options1 } from 'pug'
import type { VueLoaderOptions } from 'vue-loader'
import type { Options as Options2 } from 'sass-loader'
import type { BasePluginOptions, DefinedDefaultMinimizerAndOptions } from 'css-minimizer-webpack-plugin'
import type { Configuration, WebpackError } from 'webpack'
import type { ProcessOptions } from 'postcss'
import type { Options as Options3 } from 'webpack-dev-middleware'
import type { IncomingMessage, ServerResponse } from 'http'
import type { MiddlewareOptions, ClientOptions } from 'webpack-hot-middleware'
export interface ConfigSchema {
 components: boolean | ComponentsOptions | ComponentsOptions['dirs'],

 imports: ImportsOptions,

 pages: boolean,

 telemetry: boolean | Record<string, any>,

 devtools:  { enabled: boolean, [key: string]: any } ,

 vue: {
  compilerOptions: CompilerOptions,

  /** @default false */
  runtimeCompiler: boolean,

  /** @default false */
  propsDestructure: boolean,

  /** @default false */
  defineModel: boolean,
 },

 app: {
  /** @default "/" */
  baseURL: string,

  /** @default "/_nuxt/" */
  buildAssetsDir: string,

  /** @default "" */
  cdnURL: string,

  head: NuxtAppConfig['head'],

  /** @default false */
  layoutTransition: NuxtAppConfig['layoutTransition'],

  /** @default false */
  pageTransition: NuxtAppConfig['pageTransition'],

  /** @default false */
  keepalive: NuxtAppConfig['keepalive'],

  /** @default "__nuxt" */
  rootId: string | false,

  /** @default "div" */
  rootTag: string,
 },

 spaLoadingTemplate: string | boolean,

 plugins: (NuxtPlugin | string)[],

 css: string[],

 /** @default "@nuxt/vite-builder" */
 builder: 'vite' | 'webpack' | { bundle: (nuxt: Nuxt) => Promise<void> },

 sourcemap: boolean | { server?: boolean | 'hidden', client?: boolean | 'hidden' },

 /** @default "info" */
 logLevel: 'silent' | 'info' | 'verbose',

 build: {
  transpile: Array<string | RegExp | ((ctx: { isClient?: boolean; isServer?: boolean; isDev: boolean }) => string | RegExp | false)>,

  templates: NuxtTemplate<any>[],

  analyze: boolean | { enabled?: boolean } & ((0 extends 1 & BundleAnalyzerPlugin.Options ? {} : BundleAnalyzerPlugin.Options) | PluginVisualizerOptions),
 },

 optimization: {
  /** @default [{"name":"defineNuxtComponent","argumentLength":2},{"name":"useState","argumentLength":2},{"name":"useFetch","argumentLength":3},{"name":"useAsyncData","argumentLength":3},{"name":"useLazyAsyncData","argumentLength":3},{"name":"useLazyFetch","argumentLength":3}] */
  keyedComposables: Array<{ name: string, source?: string | RegExp, argumentLength: number }>,

  treeShake: {
   composables: {
    server: {
     [key: string]: any
    },

    client: {
     [key: string]: any
    },
   },
  },

  asyncTransforms: TransformerOptions,
 },

 extends: string | [string, SourceOptions?] | (string | [string, SourceOptions?])[],

 /** @default null */
 theme: string,

 /** @default "/<rootDir>" */
 rootDir: string,

 /** @default "/<rootDir>" */
 workspaceDir: string,

 /** @default "/<rootDir>" */
 srcDir: string,

 /** @default "/<rootDir>/server" */
 serverDir: string,

 /** @default "/<rootDir>/.nuxt" */
 buildDir: string,

 /** @default ["/<rootDir>/node_modules","/Users/daniel/code/nuxt.js/packages/schema/node_modules"] */
 modulesDir: Array<string>,

 /** @default "/<rootDir>/.nuxt/analyze" */
 analyzeDir: string,

 /** @default false */
 dev: boolean,

 /** @default false */
 test: boolean,

 /** @default false */
 debug: boolean,

 /** @default true */
 ssr: boolean,

 modules: (NuxtModule | string | [NuxtModule | string, Record<string, any>] | undefined | null | false)[],

 dir: {
  /** @default "assets" */
  assets: string,

  /** @default "layouts" */
  layouts: string,

  /** @default "middleware" */
  middleware: string,

  /** @default "modules" */
  modules: string,

  /** @default "pages" */
  pages: string,

  /** @default "plugins" */
  plugins: string,

  /** @default "public" */
  public: string,

  /**
   * @default "public"
   * 
   * @deprecated use `dir.public` option instead
  */
  static: string,
 },

 /** @default [".js",".jsx",".mjs",".ts",".tsx",".vue"] */
 extensions: Array<string>,

 alias: Record<string, string>,

 ignoreOptions: Options,

 /** @default "-" */
 ignorePrefix: string,

 /** @default ["**\/*.stories.{js,cts,mts,ts,jsx,tsx}","**\/*.{spec,test}.{js,cts,mts,ts,jsx,tsx}","**\/*.d.{cts,mts,ts}","**\/.{pnpm-store,vercel,netlify,output,git,cache,data}",".nuxt/analyze",".nuxt","**\/-*.*"] */
 ignore: Array<string>,

 watch: Array<string | RegExp>,

 watchers: {
  rewatchOnRawEvents: any,

  webpack: {
   /** @default 1000 */
   aggregateTimeout: number,
  },

  chokidar: {
   /** @default true */
   ignoreInitial: boolean,
  },
 },

 hooks: NuxtHooks,

 runtimeConfig: RuntimeConfig,

 appConfig: AppConfig,

 devServer: {
  /** @default false */
  https: boolean | { key: string; cert: string },

  /** @default 3000 */
  port: number,

  host: any,

  /** @default "http://localhost:3000" */
  url: string,

  loadingTemplate: (data: { loading?: string }) => string,
 },

 experimental: {
  /** @default false */
  asyncEntry: boolean,

  /** @default false */
  reactivityTransform: boolean,

  /** @default true */
  externalVue: boolean,

  /** @default true */
  treeshakeClientOnly: boolean,

  /** @default "automatic" */
  emitRouteChunkError: false | 'manual' | 'automatic',

  /** @default true */
  templateRouteInjection: boolean,

  /** @default false */
  restoreState: boolean,

  /** @default true */
  inlineSSRStyles: boolean | ((id?: string) => boolean),

  /** @default false */
  noScripts: boolean,

  /** @default true */
  renderJsonPayloads: boolean,

  /** @default false */
  noVueServer: boolean,

  /** @default true */
  payloadExtraction: boolean | undefined,

  /** @default false */
  clientFallback: boolean,

  /** @default false */
  crossOriginPrefetch: boolean,

  /** @default false */
  viewTransition: boolean,

  /** @default false */
  writeEarlyHints: boolean,

  /** @default false */
  componentIslands: true | 'local' | 'local+remote' | false,

  /** @default true */
  configSchema: boolean,

  /** @default false */
  typescriptBundlerResolution: boolean,

  /** @default false */
  polyfillVueUseHead: boolean,

  /** @default false */
  respectNoSSRHeader: boolean,

  /** @default true */
  localLayerAliases: boolean,

  /** @default false */
  typedPages: boolean,

  /** @default true */
  appManifest: boolean,

  /** @default "chokidar-granular" */
  watcher: 'chokidar' | 'parcel' | 'chokidar-granular',

  /** @default false */
  asyncContext: boolean,

  /** @default false */
  headNext: boolean,

  /** @default false */
  inlineRouteRules: boolean,

  defaults: {
   nuxtLink: NuxtLinkOptions,

   useAsyncData: {
    /** @default true */
    deep: boolean,
   },

   useFetch: Pick<FetchOptions, 'timeout' | 'retry' | 'retryDelay' | 'retryStatusCodes'>,
  },
 },

 generate: {
  routes: string | string[],

  exclude: Array<any>,
 },

 /** @default 3 */
 _majorVersion: number,

 /** @default false */
 _legacyGenerate: boolean,

 /** @default false */
 _start: boolean,

 /** @default false */
 _build: boolean,

 /** @default false */
 _generate: boolean,

 /** @default false */
 _prepare: boolean,

 /** @default false */
 _cli: boolean,

 _requiredModules: any,

 _nuxtConfigFile: any,

 _nuxtConfigFiles: Array<any>,

 /** @default "" */
 appDir: string,

 _installedModules: Array<any>,

 _modules: Array<any>,

 nitro: NitroConfig,

 routeRules: NitroConfig['routeRules'],

 serverHandlers: NitroEventHandler[],

 devServerHandlers: NitroDevEventHandler[],

 postcss: {
  plugins: Record<string, any> & { autoprefixer?: any; cssnano?: any },
 },

 router: {
  options: RouterConfigSerializable,
 },

 typescript: {
  /** @default true */
  strict: boolean,

  builder: 'vite' | 'webpack' | 'shared' | false | undefined,

  /** @default false */
  includeWorkspace: boolean,

  /** @default false */
  typeCheck: boolean | 'build',

  tsConfig: TSConfig,

  /** @default true */
  shim: boolean,
 },

 vite: ViteConfig & { $client?: ViteConfig, $server?: ViteConfig },

 webpack: {
  analyze: boolean | { enabled?: boolean } & BundleAnalyzerPlugin.Options,

  /** @default false */
  profile: boolean,

  /** @default true */
  extractCSS: boolean | PluginOptions,

  /** @default false */
  cssSourceMap: boolean,

  /** @default "url" */
  serverURLPolyfill: string,

  filenames: 
   Record<
     string,
     string |
     ((
       ctx: {
         nuxt: import('../src/types/nuxt').Nuxt,
         options: import('../src/types/nuxt').Nuxt['options'],
         name: string,
         isDev: boolean,
         isServer: boolean,
         isClient: boolean,
         alias: { [index: string]: string | false | string[] },
         transpile: RegExp[]
       }) => string)
   >
  ,

  loaders: {
   esbuild: Omit<LoaderOptions, 'loader'>,

   file: Omit<Options0, 'name'>,

   fontUrl: Omit<Options0, 'name'>,

   imgUrl: Omit<Options0, 'name'>,

   pugPlain: Options1,

   vue: Partial<VueLoaderOptions>,

   css: {
    /** @default 0 */
    importLoaders: number,

    url: {
     filter: () => any,
    },

    /** @default false */
    esModule: boolean,
   },

   cssModules: {
    /** @default 0 */
    importLoaders: number,

    url: {
     filter: () => any,
    },

    /** @default false */
    esModule: boolean,

    modules: {
     /** @default "[local]_[hash:base64:5]" */
     localIdentName: string,
    },
   },

   less: any,

   sass: Options2,

   scss: Options2,

   stylus: any,

   vueStyle: any,
  },

  plugins: Array<any>,

  /** @default false */
  aggressiveCodeRemoval: boolean,

  /** @default false */
  optimizeCSS: false | BasePluginOptions & DefinedDefaultMinimizerAndOptions<any>,

  optimization: false | Configuration['optimization'],

  postcss: { execute?: boolean, postcssOptions: ProcessOptions, sourceMap?: boolean, implementation?: any },

  devMiddleware: Options3<IncomingMessage, ServerResponse>,

  hotMiddleware: MiddlewareOptions & { client?: ClientOptions },

  /** @default true */
  friendlyErrors: boolean,

  warningIgnoreFilters: Array<(warn: WebpackError) => boolean>,

  experiments: false | Configuration['experiments'],
 },
}