 

# `components`

# `imports`

## `global`
- **Type**: `boolean`
- **Default**: `false`


## `dirs`
- **Type**: `array`
- **Default**: `[]`


# `pages`
- **Type**: `boolean`
- **Default**: `undefined`


# `telemetry`
- **Type**: `boolean | Record<string, any>`
- **Default**: `{}`


# `devtools`
- **Type**: ` { enabled: boolean, [key: string]: any } `
- **Default**: `{}`


# `vue`

## `compilerOptions`
- **Type**: `@vueCompilerCoreCompilerOptions`
- **Default**: `{}`


## `runtimeCompiler`
- **Type**: `boolean`
- **Default**: `false`


## `propsDestructure`
- **Type**: `boolean`
- **Default**: `false`


## `defineModel`
- **Type**: `boolean`
- **Default**: `false`


# `app`

## `baseURL`
- **Type**: `string`
- **Default**: `"/"`


## `buildAssetsDir`
- **Type**: `string`
- **Default**: `"/_nuxt/"`


## `cdnURL`
- **Type**: `string`
- **Default**: `""`


## `head`

## `layoutTransition`
- **Type**: `SrcTypesConfigNuxtAppConfig['layoutTransition']`
- **Default**: `false`


## `pageTransition`
- **Type**: `SrcTypesConfigNuxtAppConfig['pageTransition']`
- **Default**: `false`


## `keepalive`
- **Type**: `SrcTypesConfigNuxtAppConfig['keepalive']`
- **Default**: `false`


## `rootId`
- **Type**: `string | false`
- **Default**: `"__nuxt"`


## `rootTag`
- **Type**: `string`
- **Default**: `"div"`


# `spaLoadingTemplate`
- **Type**: `string | boolean`
- **Default**: `null`


# `plugins`
- **Type**: `(SrcTypesNuxtNuxtPlugin | string)[]`
- **Default**: `[]`


# `css`
- **Type**: `string[]`
- **Default**: `[]`


# `builder`
- **Type**: `'vite' | 'webpack' | { bundle: (nuxt: SrcTypesNuxtNuxt) => Promise<void> }`
- **Default**: `"@nuxt/vite-builder"`


# `sourcemap`

# `logLevel`
- **Type**: `'silent' | 'info' | 'verbose'`
- **Default**: `"info"`


# `build`

## `transpile`
- **Type**: `Array<string | RegExp | ((ctx: { isClient?: boolean; isServer?: boolean; isDev: boolean }) => string | RegExp | false)>`
- **Default**: `[]`


## `templates`
- **Type**: `SrcTypesNuxtNuxtTemplate<any>[]`
- **Default**: `[]`


## `analyze`

# `optimization`

## `keyedComposables`
- **Type**: `Array<{ name: string, source?: string | RegExp, argumentLength: number }>`
- **Default**: `[{"name":"defineNuxtComponent","argumentLength":2},{"name":"useState","argumentLength":2},{"name":"useFetch","argumentLength":3},{"name":"useAsyncData","argumentLength":3},{"name":"useLazyAsyncData","argumentLength":3},{"name":"useLazyFetch","argumentLength":3}]`


## `treeShake`

### `composables`

#### `server`

#### `client`

## `asyncTransforms`

### `asyncFunctions`
- **Type**: `array`
- **Default**: `["defineNuxtPlugin","defineNuxtRouteMiddleware"]`


### `objectDefinitions`

#### `defineNuxtComponent`
- **Type**: `array`
- **Default**: `["asyncData","setup"]`


#### `defineNuxtPlugin`
- **Type**: `array`
- **Default**: `["setup"]`


#### `definePageMeta`
- **Type**: `array`
- **Default**: `["middleware","validate"]`


# `extends`
- **Type**: `string | [string, C12SourceOptions?] | (string | [string, C12SourceOptions?])[]`
- **Default**: `null`


# `theme`
- **Type**: `string`
- **Default**: `null`


# `rootDir`
- **Type**: `string`
- **Default**: `"/<rootDir>"`


# `workspaceDir`
- **Type**: `string`
- **Default**: `"/<rootDir>"`


# `srcDir`
- **Type**: `string`
- **Default**: `"/<rootDir>"`


# `serverDir`
- **Type**: `string`
- **Default**: `"/<rootDir>/server"`


# `buildDir`
- **Type**: `string`
- **Default**: `"/<rootDir>/.nuxt"`


# `modulesDir`
- **Type**: `array`
- **Default**: `["/<rootDir>/node_modules","/Users/daniel/code/nuxt.js/packages/schema/node_modules"]`


# `analyzeDir`
- **Type**: `string`
- **Default**: `"/<rootDir>/.nuxt/analyze"`


# `dev`
- **Type**: `boolean`
- **Default**: `false`


# `test`
- **Type**: `boolean`
- **Default**: `false`


# `debug`
- **Type**: `boolean`
- **Default**: `false`


# `ssr`
- **Type**: `boolean`
- **Default**: `true`


# `modules`
- **Type**: `(SrcTypesModuleNuxtModule | string | [SrcTypesModuleNuxtModule | string, Record<string, any>] | undefined | null | false)[]`
- **Default**: `[]`


# `dir`

## `assets`
- **Type**: `string`
- **Default**: `"assets"`


## `layouts`
- **Type**: `string`
- **Default**: `"layouts"`


## `middleware`
- **Type**: `string`
- **Default**: `"middleware"`


## `modules`
- **Type**: `string`
- **Default**: `"modules"`


## `pages`
- **Type**: `string`
- **Default**: `"pages"`


## `plugins`
- **Type**: `string`
- **Default**: `"plugins"`


## `public`
- **Type**: `string`
- **Default**: `"public"`


## `static`
- **Type**: `string`
- **Default**: `"public"`


# `extensions`
- **Type**: `array`
- **Default**: `[".js",".jsx",".mjs",".ts",".tsx",".vue"]`


# `alias`

# `ignoreOptions`
- **Type**: `IgnoreOptions`
- **Default**: `{}`


# `ignorePrefix`
- **Type**: `string`
- **Default**: `"-"`


# `ignore`
- **Type**: `array`
- **Default**: `["**/*.stories.{js,cts,mts,ts,jsx,tsx}","**/*.{spec,test}.{js,cts,mts,ts,jsx,tsx}","**/*.d.{cts,mts,ts}","**/.{pnpm-store,vercel,netlify,output,git,cache,data}",".nuxt/analyze",".nuxt","**/-*.*"]`


# `watch`
- **Type**: `Array<string | RegExp>`
- **Default**: `[]`


# `watchers`

## `rewatchOnRawEvents`
- **Type**: `any`
- **Default**: `{}`


## `webpack`

### `aggregateTimeout`
- **Type**: `number`
- **Default**: `1000`


## `chokidar`

### `ignoreInitial`
- **Type**: `boolean`
- **Default**: `true`


# `hooks`
- **Type**: `SrcTypesHooksNuxtHooks`
- **Default**: `null`


# `runtimeConfig`

# `appConfig`

## `nuxt`
- **Type**: `any`
- **Default**: `{}`


# `devServer`

## `https`
- **Type**: `boolean | { key: string; cert: string }`
- **Default**: `false`


## `port`
- **Type**: `number`
- **Default**: `3000`


## `host`
- **Type**: `any`
- **Default**: `{}`


## `url`
- **Type**: `string`
- **Default**: `"http://localhost:3000"`


## `loadingTemplate`
- **Type**: `(data: { loading?: string }) => string`
- **Default**: `undefined`

```ts
() => any
```


# `experimental`

## `asyncEntry`
- **Type**: `boolean`
- **Default**: `false`


## `reactivityTransform`
- **Type**: `boolean`
- **Default**: `false`


## `externalVue`
- **Type**: `boolean`
- **Default**: `true`


## `treeshakeClientOnly`
- **Type**: `boolean`
- **Default**: `true`


## `emitRouteChunkError`
- **Type**: `false | 'manual' | 'automatic'`
- **Default**: `"automatic"`


## `templateRouteInjection`
- **Type**: `boolean`
- **Default**: `true`


## `restoreState`
- **Type**: `boolean`
- **Default**: `false`


## `inlineSSRStyles`
- **Type**: `boolean | ((id?: string) => boolean)`
- **Default**: `true`


## `noScripts`
- **Type**: `boolean`
- **Default**: `false`


## `renderJsonPayloads`
- **Type**: `boolean`
- **Default**: `true`


## `noVueServer`
- **Type**: `boolean`
- **Default**: `false`


## `payloadExtraction`
- **Type**: `boolean | undefined`
- **Default**: `true`


## `clientFallback`
- **Type**: `boolean`
- **Default**: `false`


## `crossOriginPrefetch`
- **Type**: `boolean`
- **Default**: `false`


## `viewTransition`
- **Type**: `boolean`
- **Default**: `false`


## `writeEarlyHints`
- **Type**: `boolean`
- **Default**: `false`


## `componentIslands`
- **Type**: `true | 'local' | 'local+remote' | false`
- **Default**: `false`


## `configSchema`
- **Type**: `boolean`
- **Default**: `true`


## `typescriptBundlerResolution`
- **Type**: `boolean`
- **Default**: `false`


## `polyfillVueUseHead`
- **Type**: `boolean`
- **Default**: `false`


## `respectNoSSRHeader`
- **Type**: `boolean`
- **Default**: `false`


## `localLayerAliases`
- **Type**: `boolean`
- **Default**: `true`


## `typedPages`
- **Type**: `boolean`
- **Default**: `false`


## `appManifest`
- **Type**: `boolean`
- **Default**: `true`


## `watcher`
- **Type**: `'chokidar' | 'parcel' | 'chokidar-granular'`
- **Default**: `"chokidar-granular"`


## `asyncContext`
- **Type**: `boolean`
- **Default**: `false`


## `headNext`
- **Type**: `boolean`
- **Default**: `false`


## `inlineRouteRules`
- **Type**: `boolean`
- **Default**: `false`


## `defaults`

### `nuxtLink`

#### `componentName`
- **Type**: `string`
- **Default**: `"NuxtLink"`


### `useAsyncData`

#### `deep`
- **Type**: `boolean`
- **Default**: `true`


### `useFetch`
- **Type**: `Pick<OfetchFetchOptions, 'timeout' | 'retry' | 'retryDelay' | 'retryStatusCodes'>`
- **Default**: `{}`


# `generate`

## `routes`
- **Type**: `string | string[]`
- **Default**: `[]`


## `exclude`
- **Type**: `array`
- **Default**: `[]`


# `_majorVersion`
- **Type**: `number`
- **Default**: `3`


# `_legacyGenerate`
- **Type**: `boolean`
- **Default**: `false`


# `_start`
- **Type**: `boolean`
- **Default**: `false`


# `_build`
- **Type**: `boolean`
- **Default**: `false`


# `_generate`
- **Type**: `boolean`
- **Default**: `false`


# `_prepare`
- **Type**: `boolean`
- **Default**: `false`


# `_cli`
- **Type**: `boolean`
- **Default**: `false`


# `_requiredModules`
- **Type**: `any`
- **Default**: `{}`


# `_nuxtConfigFile`
- **Type**: `any`
- **Default**: `{}`


# `_nuxtConfigFiles`
- **Type**: `array`
- **Default**: `[]`


# `appDir`
- **Type**: `string`
- **Default**: `""`


# `_installedModules`
- **Type**: `array`
- **Default**: `[]`


# `_modules`
- **Type**: `array`
- **Default**: `[]`


# `nitro`

## `routeRules`

# `routeRules`
- **Type**: `NitropackNitroConfig['routeRules']`
- **Default**: `{}`


# `serverHandlers`
- **Type**: `NitropackNitroEventHandler[]`
- **Default**: `[]`


# `devServerHandlers`
- **Type**: `NitropackNitroDevEventHandler[]`
- **Default**: `[]`


# `postcss`

## `plugins`

### `autoprefixer`
- **Type**: `any`
- **Default**: `{}`


### `cssnano`

# `router`

## `options`

### `hashMode`
- **Type**: `SrcTypesRouterRouterConfigSerializable['hashMode']`
- **Default**: `false`


### `scrollBehaviorType`
- **Type**: `SrcTypesRouterRouterConfigSerializable['scrollBehaviorType']`
- **Default**: `"auto"`


# `typescript`

## `strict`
- **Type**: `boolean`
- **Default**: `true`


## `builder`
- **Type**: `'vite' | 'webpack' | 'shared' | false | undefined`
- **Default**: `null`


## `includeWorkspace`
- **Type**: `boolean`
- **Default**: `false`


## `typeCheck`
- **Type**: `boolean | 'build'`
- **Default**: `false`


## `tsConfig`

## `shim`
- **Type**: `boolean`
- **Default**: `true`


# `vite`

## `root`
- **Type**: `string`
- **Default**: `"/<rootDir>"`


## `mode`
- **Type**: `string`
- **Default**: `"production"`


## `define`

## `resolve`

### `extensions`
- **Type**: `array`
- **Default**: `[".mjs",".js",".ts",".jsx",".tsx",".json",".vue"]`


## `publicDir`
- **Type**: `string`
- **Default**: `"/<rootDir>/public"`


## `vue`

### `isProduction`
- **Type**: `boolean`
- **Default**: `true`


### `template`

#### `compilerOptions`

### `script`

#### `propsDestructure`
- **Type**: `boolean`
- **Default**: `false`


#### `defineModel`
- **Type**: `boolean`
- **Default**: `false`


## `vueJsx`

## `optimizeDeps`

### `exclude`
- **Type**: `array`
- **Default**: `["vue-demi"]`


## `esbuild`

### `jsxFactory`
- **Type**: `string`
- **Default**: `"h"`


### `jsxFragment`
- **Type**: `string`
- **Default**: `"Fragment"`


### `tsconfigRaw`
- **Type**: `string`
- **Default**: `"{}"`


## `clearScreen`
- **Type**: `boolean`
- **Default**: `true`


## `build`

### `assetsDir`
- **Type**: `string`
- **Default**: `"_nuxt/"`


### `emptyOutDir`
- **Type**: `boolean`
- **Default**: `false`


## `server`

### `fs`

#### `allow`
- **Type**: `array`
- **Default**: `["/<rootDir>/.nuxt","/<rootDir>","/<rootDir>","/<rootDir>","/<rootDir>/node_modules","/Users/daniel/code/nuxt.js/packages/schema/node_modules"]`


# `webpack`

## `analyze`

## `profile`
- **Type**: `boolean`
- **Default**: `false`


## `extractCSS`
- **Type**: `boolean | MiniCssExtractPluginPluginOptions`
- **Default**: `true`


## `cssSourceMap`
- **Type**: `boolean`
- **Default**: `false`


## `serverURLPolyfill`
- **Type**: `string`
- **Default**: `"url"`


## `filenames`

### `app`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


### `chunk`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


### `css`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


### `img`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


### `font`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


### `video`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


## `loaders`

### `esbuild`
- **Type**: `Omit<EsbuildLoaderLoaderOptions, 'loader'>`
- **Default**: `{}`


### `file`

#### `esModule`
- **Type**: `boolean`
- **Default**: `false`


### `fontUrl`

#### `esModule`
- **Type**: `boolean`
- **Default**: `false`


#### `limit`
- **Type**: `number`
- **Default**: `1000`


### `imgUrl`

#### `esModule`
- **Type**: `boolean`
- **Default**: `false`


#### `limit`
- **Type**: `number`
- **Default**: `1000`


### `pugPlain`
- **Type**: `PugOptions`
- **Default**: `{}`


### `vue`

#### `transformAssetUrls`

##### `video`
- **Type**: `string`
- **Default**: `"src"`


##### `source`
- **Type**: `string`
- **Default**: `"src"`


##### `object`
- **Type**: `string`
- **Default**: `"src"`


##### `embed`
- **Type**: `string`
- **Default**: `"src"`


#### `compilerOptions`

#### `propsDestructure`
- **Type**: `boolean`
- **Default**: `false`


#### `defineModel`
- **Type**: `boolean`
- **Default**: `false`


### `css`

#### `importLoaders`
- **Type**: `number`
- **Default**: `0`


#### `url`

##### `filter`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


#### `esModule`
- **Type**: `boolean`
- **Default**: `false`


### `cssModules`

#### `importLoaders`
- **Type**: `number`
- **Default**: `0`


#### `url`

##### `filter`
- **Type**: `function`
- **Default**: `undefined`

```ts
() => any
```


#### `esModule`
- **Type**: `boolean`
- **Default**: `false`


#### `modules`

##### `localIdentName`
- **Type**: `string`
- **Default**: `"[local]_[hash:base64:5]"`


### `less`
- **Type**: `any`
- **Default**: `{"sourceMap":false}`


### `sass`

#### `sassOptions`

##### `indentedSyntax`
- **Type**: `boolean`
- **Default**: `true`


### `scss`
- **Type**: `SassLoaderOptions`
- **Default**: `{"sourceMap":false}`


### `stylus`
- **Type**: `any`
- **Default**: `{"sourceMap":false}`


### `vueStyle`
- **Type**: `any`
- **Default**: `{"sourceMap":false}`


## `plugins`
- **Type**: `array`
- **Default**: `[]`


## `aggressiveCodeRemoval`
- **Type**: `boolean`
- **Default**: `false`


## `optimizeCSS`
- **Type**: `false | CssMinimizerWebpackPluginBasePluginOptions & CssMinimizerWebpackPluginDefinedDefaultMinimizerAndOptions<any>`
- **Default**: `false`


## `optimization`

### `runtimeChunk`
- **Type**: `string`
- **Default**: `"single"`


### `minimize`
- **Type**: `boolean`
- **Default**: `true`


### `minimizer`
- **Type**: `any`
- **Default**: `{}`


### `splitChunks`

#### `chunks`
- **Type**: `string`
- **Default**: `"all"`


#### `automaticNameDelimiter`
- **Type**: `string`
- **Default**: `"/"`


#### `cacheGroups`
- **Type**: `any`
- **Default**: `{}`


## `postcss`

### `postcssOptions`

#### `config`
- **Type**: `any`
- **Default**: `{}`


#### `plugins`

## `devMiddleware`

### `stats`
- **Type**: `string`
- **Default**: `"none"`


## `hotMiddleware`
- **Type**: `WebpackHotMiddlewareMiddlewareOptions & { client?: WebpackHotMiddlewareClientOptions }`
- **Default**: `{}`


## `friendlyErrors`
- **Type**: `boolean`
- **Default**: `true`


## `warningIgnoreFilters`
- **Type**: `Array<(warn: WebpackWebpackError) => boolean>`
- **Default**: `[]`


## `experiments`
- **Type**: `false | WebpackConfiguration['experiments']`
- **Default**: `{}`
