import { promises } from 'node:fs';
import { c as createApp, e as eventHandler, l as lazyEventHandler, t as toNodeListener } from '../shared/nuxi.a4b9172a.mjs';
import { listen } from './index2.mjs';
import { d as defu } from '../shared/nuxi.0508e766.mjs';
import { l as loadKit } from '../shared/nuxi.0c472721.mjs';
import { c as clearDir } from '../shared/nuxi.976cd438.mjs';
import { o as overrideEnv } from '../shared/nuxi.2509f57e.mjs';
import { d as defineCommand } from '../shared/nuxi.4fde776c.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve, j as join } from '../shared/nuxi.5c071e73.mjs';
import '../shared/nuxi.cda6864c.mjs';
import 'node:http';
import 'node:https';
import 'node:util';
import 'node:net';
import 'node:os';
import '../shared/nuxi.2155838d.mjs';
import 'http';
import 'https';
import 'node:path';
import 'node:process';
import 'node:tty';
import 'node:child_process';
import 'crypto';
import 'node:fs/promises';
import '../shared/nuxi.70ab727b.mjs';
import 'node:url';
import 'node:module';
import 'node:assert';
import 'node:v8';
import 'node:perf_hooks';
import './satisfies.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.b3d5700f.mjs';
import 'fs';
import 'module';
import 'path';
import 'perf_hooks';
import 'os';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'util';
import 'tty';
import 'stream';
import 'events';
import 'node:stream';

const analyze = defineCommand({
  meta: {
    name: "analyze",
    description: "Build nuxt and analyze production bundle (experimental)"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs,
    name: {
      type: "string",
      description: "Name of the analysis",
      default: "default"
    },
    serve: {
      type: "boolean",
      description: "Serve the analysis results",
      default: true
    }
  },
  async run(ctx) {
    overrideEnv("production");
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    const name = ctx.args.name || "default";
    const slug = name.trim().replace(/[^a-z0-9_-]/gi, "_");
    const startTime = Date.now();
    const { loadNuxt, buildNuxt } = await loadKit(cwd);
    const nuxt = await loadNuxt({
      rootDir: cwd,
      overrides: defu(ctx.data?.overrides, {
        build: {
          analyze: {
            enabled: true
          }
        },
        logLevel: ctx.args.logLevel
      })
    });
    const analyzeDir = nuxt.options.analyzeDir;
    const buildDir = nuxt.options.buildDir;
    const outDir = nuxt.options.nitro.output?.dir || join(nuxt.options.rootDir, ".output");
    nuxt.options.build.analyze = defu(nuxt.options.build.analyze, {
      filename: join(analyzeDir, "client.html")
    });
    await clearDir(analyzeDir);
    await buildNuxt(nuxt);
    const endTime = Date.now();
    const meta = {
      name,
      slug,
      startTime,
      endTime,
      analyzeDir,
      buildDir,
      outDir
    };
    await nuxt.callHook("build:analyze:done", meta);
    await promises.writeFile(
      join(analyzeDir, "meta.json"),
      JSON.stringify(meta, null, 2),
      "utf-8"
    );
    console.info("Analyze results are available at: `" + analyzeDir + "`");
    console.warn(
      "Do not deploy analyze results! Use `nuxi build` before deploying."
    );
    if (ctx.args.serve !== false && !process.env.CI) {
      const app = createApp();
      const serveFile = (filePath) => lazyEventHandler(async () => {
        const contents = await promises.readFile(filePath, "utf-8");
        return eventHandler((event) => {
          event.node.res.end(contents);
        });
      });
      console.info("Starting stats server...");
      app.use("/client", serveFile(join(analyzeDir, "client.html")));
      app.use("/nitro", serveFile(join(analyzeDir, "nitro.html")));
      app.use(
        eventHandler(
          () => `<!DOCTYPE html>
        <html lang="en">
        <head>
        <meta charset="utf-8">
        <title>Nuxt Bundle Stats (experimental)</title>
        </head>
          <h1>Nuxt Bundle Stats (experimental)</h1>
          <ul>
            <li>
              <a href="/nitro">Nitro server bundle stats</a>
            </li>
            <li>
              <a href="/client">Client bundle stats</a>
            </li>
          </ul>
        </html>
      `
        )
      );
      await listen(toNodeListener(app));
    }
  }
});

export { analyze as default };
