import { c as cleanupNuxtDirs } from '../shared/nuxi.6344d342.mjs';
import { d as defineCommand } from '../shared/nuxi.4fde776c.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve } from '../shared/nuxi.5c071e73.mjs';
import { l as loadKit } from '../shared/nuxi.0c472721.mjs';
import 'node:fs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import '../shared/nuxi.976cd438.mjs';
import 'node:url';
import '../shared/nuxi.70ab727b.mjs';
import 'node:module';
import '../shared/nuxi.cda6864c.mjs';
import 'node:assert';
import 'node:v8';
import 'node:perf_hooks';
import '../shared/nuxi.0508e766.mjs';
import './satisfies.mjs';
import '../shared/nuxi.2155838d.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.b3d5700f.mjs';
import 'crypto';
import 'fs';
import 'module';
import 'path';
import 'perf_hooks';
import 'os';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'util';
import 'tty';
import 'stream';
import 'events';
import 'node:stream';

const cleanup = defineCommand({
  meta: {
    name: "cleanup",
    description: "Cleanup generated nuxt files and caches"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs
  },
  async run(ctx) {
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    const { loadNuxtConfig } = await loadKit(cwd);
    const nuxtOptions = await loadNuxtConfig({ cwd });
    await cleanupNuxtDirs(nuxtOptions.rootDir, nuxtOptions.buildDir);
  }
});

export { cleanup as default };
