import { d as defineCommand, c as consola, a as c } from '../shared/nuxi.4fde776c.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import { o as overrideEnv } from '../shared/nuxi.2509f57e.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve } from '../shared/nuxi.5c071e73.mjs';
import { createNuxtDevServer } from './dev2.mjs';
import 'node:url';
import 'node:events';
import '../shared/nuxi.7fc2c517.mjs';
import 'events';
import 'fs';
import 'path';
import 'util';
import 'stream';
import '../shared/nuxi.0c472721.mjs';
import '../shared/nuxi.70ab727b.mjs';
import 'node:module';
import 'node:fs';
import '../shared/nuxi.cda6864c.mjs';
import 'node:assert';
import 'node:v8';
import 'node:perf_hooks';
import '../shared/nuxi.0508e766.mjs';
import './satisfies.mjs';
import '../shared/nuxi.2155838d.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.b3d5700f.mjs';
import 'crypto';
import 'module';
import 'perf_hooks';
import 'os';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'tty';
import 'node:stream';
import '../shared/nuxi.a4b9172a.mjs';
import './index2.mjs';
import 'node:http';
import 'node:https';
import 'node:net';
import 'node:os';
import 'http';
import 'https';
import 'node:child_process';
import 'node:fs/promises';
import '../shared/nuxi.6344d342.mjs';
import '../shared/nuxi.976cd438.mjs';

const devChild = defineCommand({
  meta: {
    name: "_dev",
    description: "Run nuxt development server (internal command to start child process)"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs
  },
  async run(ctx) {
    const logger = consola.withTag("nuxi");
    if (!process.send && !c) {
      logger.warn(
        "`nuxi _dev` is an internal command and should not be used directly. Please use `nuxi dev` instead."
      );
    }
    overrideEnv("development");
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    const devContext = JSON.parse(process.env.__NUXT_DEV__ || "null") || {};
    const nuxtDev = await createNuxtDevServer({
      cwd,
      overrides: ctx.data?.overrides,
      logLevel: ctx.args.logLevel,
      clear: !!ctx.args.clear,
      dotenv: !!ctx.args.dotenv,
      port: process.env._PORT ?? void 0,
      devContext
    });
    function sendIPCMessage(message) {
      if (process.send) {
        process.send(message);
      } else {
        logger.info(
          "Dev server event:",
          Object.entries(message).map((e) => e[0] + "=" + JSON.stringify(e[1])).join(" ")
        );
      }
    }
    nuxtDev.on("loading", (message) => {
      sendIPCMessage({ type: "nuxt:internal:dev:loading", message });
    });
    nuxtDev.on("restart", () => {
      sendIPCMessage({ type: "nuxt:internal:dev:restart" });
    });
    nuxtDev.on("ready", (payload) => {
      sendIPCMessage({ type: "nuxt:internal:dev:ready", port: payload.port });
    });
    await nuxtDev.init();
  }
});

export { devChild as default };
