import { fork } from 'node:child_process';
import { s as setupDotenv } from '../shared/nuxi.ca569d29.mjs';
import { d as defineCommand, S, a as c } from '../shared/nuxi.4fde776c.mjs';
import './index2.mjs';
import 'node:http';
import 'node:https';
import 'node:util';
import 'node:net';
import 'node:os';
import 'node:path';
import 'node:process';
import 'node:tty';
import 'node:fs';
import 'node:fs/promises';
import { s as showVersions } from '../shared/nuxi.39655513.mjs';
import { l as loadKit } from '../shared/nuxi.0c472721.mjs';
import { i as importModule } from '../shared/nuxi.70ab727b.mjs';
import { o as overrideEnv } from '../shared/nuxi.2509f57e.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve } from '../shared/nuxi.5c071e73.mjs';
import 'fs';
import 'path';
import 'os';
import 'crypto';
import '../shared/nuxi.2155838d.mjs';
import 'module';
import 'perf_hooks';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'util';
import 'tty';
import '../shared/nuxi.7fc2c517.mjs';
import 'events';
import 'stream';
import 'node:url';
import 'http';
import 'https';
import '../shared/nuxi.0508e766.mjs';
import '../shared/nuxi.cb18516a.mjs';
import '../shared/nuxi.2f09986c.mjs';
import 'node:module';
import 'node:perf_hooks';
import './satisfies.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.b3d5700f.mjs';
import 'node:stream';
import '../shared/nuxi.cda6864c.mjs';
import 'node:assert';
import 'node:v8';

function getArgs() {
  return {
    port: {
      type: "string",
      description: "Port to listen on (use `PORT` environment variable to override)"
    },
    host: {
      description: "Host to listen on. If no value or an empty string provided, will listen on all available interfaces (use `HOST` environment variable to override)"
    },
    clipboard: {
      type: "boolean",
      description: "Copy the URL to the clipboard"
    },
    open: {
      type: "boolean",
      description: "Open the URL in the browser"
    },
    https: {
      type: "boolean",
      description: "Enable HTTPS"
    },
    "https.cert": {
      type: "string",
      description: "Path to TLS certificate used with HTTPS in PEM format"
    },
    "https.key": {
      type: "string",
      description: "Path to TLS key used with HTTPS in PEM format"
    },
    "https.pfx": {
      type: "string",
      description: "Path to PKCS#12 (.p12/.pfx) keystore containing a TLS certificate and Key"
    },
    "https.passphrase": {
      type: "string",
      description: "Passphrase used for TLS key or keystore"
    },
    "https.validityDays": {
      type: "string",
      description: "Validity in days of the autogenerated TLS certificate (https: true)"
    },
    "https.domains": {
      type: "string",
      description: "Comma seperated list of domains and IPs, the autogenerated certificate should be valid for (https: true)"
    },
    publicURL: {
      type: "string",
      description: "Displayed public URL (used for QR code)",
      required: false
    },
    qr: {
      type: "boolean",
      description: "Display The QR code of public URL when available",
      required: false
    },
    public: {
      type: "boolean",
      description: "Listen to all network interfaces",
      required: false
    },
    tunnel: {
      type: "boolean",
      description: "Open a tunnel using https://github.com/unjs/untun",
      required: false
    }
  };
}
function parseArgs(args) {
  return {
    port: args.port,
    // prettier-ignore
    hostname: typeof args.host === "string" ? args.host : args.host === true ? "" : void 0,
    clipboard: args.clipboard,
    open: args.open,
    qr: args.qr,
    publicURL: args.publicURL,
    public: args.public,
    tunnel: args.tunnel,
    https: args.https ? {
      cert: args["https.cert"],
      key: args["https.key"],
      pfx: args["https.pfx"],
      passphrase: args["https.passphrase"],
      validityDays: args["https.validityDays"] ? +args["https.validityDays"] : void 0,
      domains: args["https.domains"] ? args["https.domains"].split(",") : void 0
    } : false
  };
}

const forkSupported = !S && !c;
const command = defineCommand({
  meta: {
    name: "dev",
    description: "Run nuxt development server"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs,
    ...getArgs(),
    dotenv: {
      type: "string",
      description: "Path to .env file"
    },
    clear: {
      type: "boolean",
      description: "Clear console on restart"
    },
    fork: {
      type: "boolean",
      description: forkSupported ? "Disable forked mode" : "Enable forked mode",
      default: forkSupported
    }
  },
  async run(ctx) {
    overrideEnv("development");
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    showVersions(cwd);
    await setupDotenv({ cwd, fileName: ctx.args.dotenv });
    const { loadNuxtConfig } = await loadKit(cwd);
    const nuxtOptions = await loadNuxtConfig({
      cwd,
      overrides: {
        dev: true,
        logLevel: ctx.args.logLevel,
        ...ctx.data?.overrides
      }
    });
    const listenOptions = _resolveListenOptions(nuxtOptions, ctx.args);
    if (ctx.args.fork) {
      const devProxy = await _createDevProxy(nuxtOptions, listenOptions);
      await _startSubprocess(devProxy, ctx.rawArgs);
      return { listener: devProxy?.listener };
    } else {
      const { createNuxtDevServer } = await import('./dev2.mjs');
      const devServer = await createNuxtDevServer(
        {
          cwd,
          overrides: ctx.data?.overrides,
          logLevel: ctx.args.logLevel,
          clear: ctx.args.clear,
          dotenv: !!ctx.args.dotenv,
          loadingTemplate: nuxtOptions.devServer.loadingTemplate,
          devContext: {}
        },
        listenOptions
      );
      await devServer.init();
      return { listener: devServer?.listener };
    }
  }
});
async function _createDevProxy(nuxtOptions, listenOptions) {
  let loadingMessage = "Nuxt dev server is starting...";
  const loadingTemplate = nuxtOptions.devServer.loadingTemplate ?? await importModule("@nuxt/ui-templates", nuxtOptions.modulesDir).then(
    (r) => r.loading
  );
  const { createProxyServer } = await import('./index4.mjs');
  const proxy = createProxyServer({});
  let address;
  const handler = (req, res) => {
    if (!address) {
      res.statusCode = 503;
      res.setHeader("Content-Type", "text/html");
      res.end(loadingTemplate({ loading: loadingMessage }));
      return;
    }
    return proxy.web(req, res, { target: address });
  };
  const wsHandler = (req, socket, head) => {
    if (!address) {
      socket.destroy();
      return;
    }
    return proxy.ws(req, socket, { target: address }, head);
  };
  const { listen } = await import('./index2.mjs');
  const listener = await listen(handler, listenOptions);
  listener.server.on("upgrade", wsHandler);
  return {
    listener,
    handler,
    wsHandler,
    setAddress: (_addr) => {
      address = _addr;
    },
    setLoadingMessage: (_msg) => {
      loadingMessage = _msg;
    }
  };
}
async function _startSubprocess(devProxy, rawArgs) {
  let childProc;
  const kill = (signal) => {
    if (childProc) {
      childProc.kill(signal);
      childProc = void 0;
    }
  };
  const restart = async () => {
    kill("SIGHUP");
    childProc = fork(globalThis.__nuxt_cli__?.entry, ["_dev", ...rawArgs], {
      execArgv: [
        "--enable-source-maps",
        process.argv.includes("--inspect") && "--inspect"
      ].filter(Boolean),
      env: {
        ...process.env,
        __NUXT_DEV__: JSON.stringify({
          proxy: {
            url: devProxy.listener.url,
            urls: await devProxy.listener.getURLs(),
            https: devProxy.listener.https
          }
        })
      }
    });
    childProc.on("close", (errorCode) => {
      if (errorCode) {
        process.exit(errorCode);
      }
    });
    childProc.on("message", (message) => {
      if (message.type === "nuxt:internal:dev:ready") {
        devProxy.setAddress(`http://127.0.0.1:${message.port}`);
      } else if (message.type === "nuxt:internal:dev:loading") {
        devProxy.setAddress(void 0);
        devProxy.setLoadingMessage(message.message);
      } else if (message.type === "nuxt:internal:dev:restart") {
        restart();
      }
    });
  };
  for (const signal of [
    "exit",
    "SIGTERM",
    "SIGINT",
    "SIGQUIT"
  ]) {
    process.once(signal, () => {
      kill(signal === "exit" ? 0 : signal);
    });
  }
  await restart();
  return {
    restart,
    kill
  };
}
function _resolveListenOptions(nuxtOptions, args) {
  const _port = args.port ?? args.p ?? process.env.NUXT_PORT ?? process.env.NITRO_PORT ?? process.env.PORT ?? nuxtOptions.devServer.port;
  const _hostname = typeof args.host === "string" ? args.host : (args.host === true ? "" : void 0) ?? process.env.NUXT_HOST ?? process.env.NITRO_HOST ?? process.env.HOST ?? // TODO: Default host in schema should be undefined instead of ''
  nuxtOptions._layers?.[0].config?.devServer?.host ?? void 0;
  const _public = args.public ?? (_hostname && !["localhost", "127.0.0.1", "::1"].includes(_hostname)) ? true : void 0;
  const _httpsCert = args["https.cert"] || args.sslCert || process.env.NUXT_SSL_CERT || process.env.NITRO_SSL_CERT || typeof nuxtOptions.devServer.https !== "boolean" && nuxtOptions.devServer.https?.cert || "";
  const _httpsKey = args["https.key"] || args.sslKey || process.env.NUXT_SSL_KEY || process.env.NITRO_SSL_KEY || typeof nuxtOptions.devServer.https !== "boolean" && nuxtOptions.devServer.https?.key || "";
  const httpsEnabled = args.https == true || args.https === void 0 && !!nuxtOptions.devServer.https;
  const _listhenOptions = parseArgs({
    ...args,
    open: args.o || args.open,
    https: httpsEnabled,
    "https.cert": _httpsCert,
    "https.key": _httpsKey
  });
  const httpsOptions = httpsEnabled && {
    ...nuxtOptions.devServer.https,
    ..._listhenOptions.https
  };
  return {
    ..._listhenOptions,
    port: _port,
    hostname: _hostname,
    public: _public,
    https: httpsOptions,
    baseURL: nuxtOptions.app.baseURL
  };
}

export { command as default };
