import EventEmitter from 'node:events';
import { c as chokidar } from '../shared/nuxi.7fc2c517.mjs';
import { c as consola } from '../shared/nuxi.4fde776c.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import { t as toNodeListener } from '../shared/nuxi.a4b9172a.mjs';
import { listen } from './index2.mjs';
import { l as loadKit } from '../shared/nuxi.0c472721.mjs';
import { l as loadNuxtManifest, w as writeNuxtManifest } from '../shared/nuxi.6344d342.mjs';
import { a as clearBuildDir } from '../shared/nuxi.976cd438.mjs';
import { i as importModule } from '../shared/nuxi.70ab727b.mjs';
import { r as resolve, a as relative } from '../shared/nuxi.5c071e73.mjs';
import 'events';
import 'fs';
import 'path';
import 'util';
import 'stream';
import 'os';
import 'node:url';
import '../shared/nuxi.cda6864c.mjs';
import 'node:http';
import 'node:https';
import 'node:net';
import 'node:os';
import '../shared/nuxi.2155838d.mjs';
import 'http';
import 'https';
import '../shared/nuxi.0508e766.mjs';
import 'node:child_process';
import 'node:fs';
import 'crypto';
import 'node:fs/promises';
import 'node:perf_hooks';
import './satisfies.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.b3d5700f.mjs';
import 'module';
import 'perf_hooks';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'tty';
import 'node:stream';
import 'node:module';
import 'node:assert';
import 'node:v8';

const DEBOUNCE_DEFAULTS = {
  trailing: true
};
function debounce(fn, wait = 25, options = {}) {
  options = { ...DEBOUNCE_DEFAULTS, ...options };
  if (!Number.isFinite(wait)) {
    throw new TypeError("Expected `wait` to be a finite number");
  }
  let leadingValue;
  let timeout;
  let resolveList = [];
  let currentPromise;
  let trailingArgs;
  const applyFn = (_this, args) => {
    currentPromise = _applyPromised(fn, _this, args);
    currentPromise.finally(() => {
      currentPromise = null;
      if (options.trailing && trailingArgs && !timeout) {
        const promise = applyFn(_this, trailingArgs);
        trailingArgs = null;
        return promise;
      }
    });
    return currentPromise;
  };
  return function(...args) {
    if (currentPromise) {
      if (options.trailing) {
        trailingArgs = args;
      }
      return currentPromise;
    }
    return new Promise((resolve) => {
      const shouldCallNow = !timeout && options.leading;
      clearTimeout(timeout);
      timeout = setTimeout(() => {
        timeout = null;
        const promise = options.leading ? leadingValue : applyFn(this, args);
        for (const _resolve of resolveList) {
          _resolve(promise);
        }
        resolveList = [];
      }, wait);
      if (shouldCallNow) {
        leadingValue = applyFn(this, args);
        resolve(leadingValue);
      } else {
        resolveList.push(resolve);
      }
    });
  };
}
async function _applyPromised(fn, _this, args) {
  return await fn.apply(_this, args);
}

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
async function createNuxtDevServer(options, listenOptions) {
  const devServer = new NuxtDevServer(options);
  devServer.listener = await listen(
    devServer.handler,
    listenOptions || {
      port: options.port ?? 0,
      hostname: "127.0.0.1",
      showURL: false
    }
  );
  devServer.listener._url = devServer.listener.url;
  if (options.devContext.proxy?.url) {
    devServer.listener.url = options.devContext.proxy.url;
  }
  if (options.devContext.proxy?.urls) {
    const _getURLs = devServer.listener.getURLs.bind(devServer.listener);
    devServer.listener.getURLs = async () => Array.from(
      /* @__PURE__ */ new Set([...options.devContext.proxy.urls, ...await _getURLs()])
    );
  }
  return devServer;
}
const RESTART_RE = /^(nuxt\.config\.(js|ts|mjs|cjs)|\.nuxtignore|\.nuxtrc)$/;
class NuxtDevServer extends EventEmitter {
  constructor(options) {
    super();
    this.options = options;
    __publicField(this, "_handler");
    __publicField(this, "_distWatcher");
    __publicField(this, "_currentNuxt");
    __publicField(this, "_loadingMessage");
    __publicField(this, "loadDebounced");
    __publicField(this, "handler");
    __publicField(this, "listener");
    this.loadDebounced = debounce(this.load);
    let _initResolve;
    const _initPromise = new Promise((resolve2) => {
      _initResolve = resolve2;
    });
    this.once("ready", () => {
      _initResolve();
    });
    this.handler = async (req, res) => {
      await _initPromise;
      if (this._handler) {
        this._handler(req, res);
      } else {
        this._renderError(res);
      }
    };
    this.listener = void 0;
  }
  async _renderError(res, _error) {
    res.statusCode = 503;
    res.setHeader("Content-Type", "text/html");
    const loadingTemplate = this.options.loadingTemplate || this._currentNuxt?.options.devServer.loadingTemplate || (await importModule("@nuxt/ui-templates", this.options.cwd).then(
      (r) => r.loading
    )).catch(() => {
    }) || ((params) => `<h2>${params.loading}</h2>`);
    res.end(
      loadingTemplate({
        loading: _error?.toString() || this._loadingMessage || "Loading..."
      })
    );
  }
  async init() {
    await this.load();
    await this._watchConfig();
  }
  async load(reload, reason) {
    try {
      await this._load(reload, reason);
    } catch (error) {
      consola.error(`Cannot ${reload ? "restart" : "start"} nuxt: `, error);
      this._handler = void 0;
      this._loadingMessage = "Error while loading nuxt. Please check console and fix errors.";
      this.emit("loading", this._loadingMessage);
    }
  }
  async _load(reload, reason) {
    const action = reload ? "Restarting" : "Starting";
    this._loadingMessage = `${reason ? reason + ". " : ""}${action} nuxt...`;
    this._handler = void 0;
    this.emit("loading", this._loadingMessage);
    if (reload) {
      consola.info(this._loadingMessage);
    }
    if (this._currentNuxt) {
      await this._currentNuxt.close();
    }
    if (this._distWatcher) {
      await this._distWatcher.close();
    }
    const kit = await loadKit(this.options.cwd);
    this._currentNuxt = await kit.loadNuxt({
      rootDir: this.options.cwd,
      dev: true,
      ready: false,
      overrides: {
        logLevel: this.options.logLevel,
        vite: {
          clearScreen: this.options.clear
        },
        nitro: {
          devErrorHandler: (error, event) => {
            this._renderError(event.node.res, error);
          }
        },
        ...this.options.overrides
      }
    });
    if (!process.env.NUXI_DISABLE_VITE_HMR) {
      this._currentNuxt.hooks.hook(
        "vite:extendConfig",
        (config, { isClient }) => {
          if (isClient && config.server) {
            config.server.hmr = {
              ...config.server.hmr,
              protocol: void 0,
              port: void 0,
              host: void 0,
              server: this.listener.server
            };
          }
        }
      );
    }
    this._currentNuxt.hooks.hookOnce("close", () => {
      this.listener.server.removeAllListeners("upgrade");
    });
    if (!reload) {
      const previousManifest = await loadNuxtManifest(
        this._currentNuxt.options.buildDir
      );
      const newManifest = await writeNuxtManifest(this._currentNuxt);
      if (previousManifest && newManifest && previousManifest._hash !== newManifest._hash) {
        await clearBuildDir(this._currentNuxt.options.buildDir);
      }
    }
    await this._currentNuxt.ready();
    const unsub = this._currentNuxt.hooks.hook("restart", async (options) => {
      unsub();
      if (options?.hard) {
        this.emit("restart");
        return;
      }
      await this.load(true);
    });
    await this._currentNuxt.hooks.callHook(
      "listen",
      this.listener.server,
      this.listener
    );
    const addr = this.listener.address;
    this._currentNuxt.options.devServer.host = addr.address;
    this._currentNuxt.options.devServer.port = addr.port;
    this._currentNuxt.options.devServer.url = _getAddressURL(
      addr,
      !!this.listener.https
    );
    this._currentNuxt.options.devServer.https = this.options.devContext.proxy?.https;
    if (this.listener.https && !process.env.NODE_TLS_REJECT_UNAUTHORIZED) {
      consola.warn(
        "You might need `NODE_TLS_REJECT_UNAUTHORIZED=0` environment vairable to make https work."
      );
    }
    await Promise.all([
      kit.writeTypes(this._currentNuxt).catch(console.error),
      kit.buildNuxt(this._currentNuxt)
    ]);
    this._distWatcher = chokidar.watch(
      resolve(this._currentNuxt.options.buildDir, "dist"),
      { ignoreInitial: true, depth: 0 }
    );
    this._distWatcher.on("unlinkDir", () => {
      this.loadDebounced(true, ".nuxt/dist directory has been removed");
    });
    this._handler = toNodeListener(this._currentNuxt.server.app);
    this.emit("ready", addr);
  }
  async _watchConfig() {
    const configWatcher = chokidar.watch([this.options.cwd], {
      ignoreInitial: true,
      depth: 0
    });
    configWatcher.on("all", (_event, _file) => {
      const file = relative(this.options.cwd, _file);
      if (file === (this.options.dotenv || ".env")) {
        this.emit("restart");
      }
      if (RESTART_RE.test(file)) {
        this.loadDebounced(true, `${file} updated`);
      }
    });
  }
}
function _getAddressURL(addr, https) {
  const proto = https ? "https" : "http";
  let host = addr.address.includes(":") ? `[${addr.address}]` : addr.address;
  if (host === "[::]") {
    host = "localhost";
  }
  const port = addr.port || 3e3;
  return `${proto}://${host}:${port}/`;
}

export { createNuxtDevServer };
