import { existsSync } from 'node:fs';
import { c as consola } from '../shared/nuxi.4fde776c.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import 'node:url';

async function startTunnel(opts) {
  const {
    installCloudflared,
    startCloudflaredTunnel,
    cloudflaredBinPath,
    cloudflaredNotice
  } = await import('./index8.mjs');
  const url = opts.url || `${opts.protocol || "http"}://${opts.hostname ?? "localhost"}:${opts.port ?? 3e3}`;
  consola.start(`Starting cloudflared tunnel to ${url}`);
  if (!existsSync(cloudflaredBinPath)) {
    consola.log(cloudflaredNotice);
    const canInstall = await consola.prompt(
      `Do you agree with the above terms and wish to install the binary from GitHub?`,
      {
        type: "confirm"
      }
    );
    if (!canInstall) {
      consola.fail("Skipping tunnel setup.");
      return;
    }
    await installCloudflared();
  }
  const args = [
    ["--url", url],
    opts.verifyTLS ? void 0 : ["--no-tls-verify", ""]
  ].filter(Boolean);
  const tunnel = await startCloudflaredTunnel(Object.fromEntries(args));
  const cleanup = async () => {
    await tunnel.stop();
  };
  for (const signal of ["SIGINT", "SIGUSR1", "SIGUSR2"]) {
    process.once(signal, cleanup);
  }
  return {
    getURL: async () => await tunnel.url,
    close: async () => {
      await cleanup();
    }
  };
}

export { startTunnel };
