import { d as defineCommand } from '../shared/nuxi.4fde776c.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve } from '../shared/nuxi.5c071e73.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import 'node:url';

const test = defineCommand({
  meta: {
    name: "test",
    description: "Run tests"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs,
    cwd: {
      type: "string",
      description: "Current working directory"
    },
    dev: {
      type: "boolean",
      description: "Run in dev mode"
    },
    watch: {
      type: "boolean",
      description: "Watch mode"
    }
  },
  async run(ctx) {
    process.env.NODE_ENV = process.env.NODE_ENV || "test";
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    const { runTests } = await importTestUtils();
    await runTests({
      rootDir: cwd,
      dev: ctx.args.dev,
      watch: ctx.args.watch,
      .../*ctx.options ||*/
      {}
    });
  }
});
async function importTestUtils() {
  let err;
  for (const pkg of [
    "@nuxt/test-utils-nightly",
    "@nuxt/test-utils-edge",
    "@nuxt/test-utils"
  ]) {
    try {
      const exports = await import(pkg);
      if (!exports.runTests) {
        throw new Error("Invalid version of `@nuxt/test-utils` is installed!");
      }
      return exports;
    } catch (_err) {
      err = _err;
    }
  }
  console.error(err);
  throw new Error(
    "`@nuxt/test-utils` seems missing. Run `npm i -D @nuxt/test-utils` or `yarn add -D @nuxt/test-utils` to install."
  );
}

export { test as default };
