import { defineNuxtModule, createResolver, addPlugin } from '@nuxt/kit';
import { defu } from 'defu';

const name = "nuxt-aos";
const version = "1.1.6";

const module = defineNuxtModule({
  meta: {
    name,
    version,
    configKey: "aos",
    compatibility: {
      nuxt: "^3.0.0"
    }
  },
  defaults: {},
  setup(options, nuxt) {
    const resolver = createResolver(import.meta.url);
    nuxt.options.runtimeConfig.public = defu(
      nuxt.options.runtimeConfig.public || {},
      {
        aos: options
      }
    );
    addPlugin(resolver.resolve("./runtime/plugin"));
  }
});

export { module as default };
