import type { NuxtPayload } from '../nuxt.js';
/**
 * Allows full control of the hydration cycle to set and receive data from the server.
 * @param key a unique key to identify the data in the Nuxt payload
 * @param get a function that returns the value to set the initial data
 * @param set a function that will receive the data on the client-side
 */
export declare const useHydration: <K extends keyof NuxtPayload, T = NuxtPayload[K]>(key: K, get: () => T, set: (value: T) => void) => void;
