import { defineNuxtRouteMiddleware } from "../composables/router.js";
import { getRouteRules } from "../composables/manifest.js";
export default defineNuxtRouteMiddleware(async (to) => {
  if (import.meta.server || import.meta.test) {
    return;
  }
  const rules = await getRouteRules(to.path);
  if (rules.redirect) {
    return rules.redirect;
  }
});
