#!/usr/bin/env node
import { defineCommand, runMain } from 'citty';
import { addDependency, installDependencies, removeDependency } from './index.mjs';
import 'node:fs';
import 'node:fs/promises';
import 'pathe';
import 'node:module';
import 'ufo';

const name = "nypm";
const version = "0.3.3";
const description = "Unified Package Manager for Node.js";
const repository = "unjs/nypm";
const license = "MIT";
const sideEffects = false;
const type = "module";
const exports = {
	".": {
		types: "./dist/index.d.ts",
		"import": "./dist/index.mjs",
		require: "./dist/index.cjs"
	}
};
const bin = {
	nypm: "./dist/cli.mjs"
};
const main$1 = "./dist/index.cjs";
const module = "./dist/index.mjs";
const types = "./dist/index.d.ts";
const files = [
	"dist"
];
const scripts = {
	build: "unbuild",
	dev: "vitest dev",
	lint: "eslint --ext .ts,.js,.mjs,.cjs . && prettier -c src test",
	"lint:fix": "eslint --ext .ts,.js,.mjs,.cjs . --fix && prettier -w src test",
	prepack: "unbuild",
	nypm: "jiti src/cli.ts",
	release: "pnpm test && pnpm build && changelogen --release --push && pnpm publish",
	test: "pnpm lint && pnpm test:types && vitest run --coverage",
	"test:types": "tsc --noEmit"
};
const dependencies = {
	citty: "^0.1.4",
	execa: "^8.0.1",
	pathe: "^1.1.1",
	ufo: "^1.3.0"
};
const devDependencies = {
	"@types/node": "^20.6.0",
	"@vitest/coverage-v8": "^0.34.4",
	changelogen: "^0.5.5",
	eslint: "^8.49.0",
	"eslint-config-unjs": "^0.2.1",
	jiti: "^1.20.0",
	prettier: "^3.0.3",
	"std-env": "^3.4.3",
	typescript: "^5.2.2",
	unbuild: "^2.0.0",
	vitest: "^0.34.4"
};
const packageManager = "pnpm@8.7.4";
const engines = {
	node: "^14.16.0 || >=16.10.0"
};
const pkg = {
	name: name,
	version: version,
	description: description,
	repository: repository,
	license: license,
	sideEffects: sideEffects,
	type: type,
	exports: exports,
	bin: bin,
	main: main$1,
	module: module,
	types: types,
	files: files,
	scripts: scripts,
	dependencies: dependencies,
	devDependencies: devDependencies,
	packageManager: packageManager,
	engines: engines
};

const operationArgs = {
  cwd: {
    type: "string",
    description: "Current working directory"
  },
  workspace: {
    type: "boolean",
    description: "Add to workspace"
  },
  silent: {
    type: "boolean",
    description: "Run in silent mode"
  }
};
const install = defineCommand({
  meta: {
    description: "Install dependencies"
  },
  args: {
    ...operationArgs,
    name: {
      type: "positional",
      description: "Dependency name",
      required: false
    },
    dev: {
      type: "boolean",
      alias: "D",
      description: "Add as dev dependency"
    }
  },
  run: async ({ args }) => {
    await (args.name ? addDependency(args.name, args) : installDependencies(args));
  }
});
const remove = defineCommand({
  meta: {
    description: "Remove dependencies"
  },
  args: {
    name: {
      type: "positional",
      description: "Dependency name",
      required: true
    },
    ...operationArgs
  },
  run: async ({ args }) => {
    await removeDependency(args.name, args);
  }
});
const main = defineCommand({
  meta: {
    name: pkg.name,
    version: pkg.version,
    description: pkg.description
  },
  subCommands: {
    install,
    i: install,
    add: install,
    remove
  }
});
runMain(main);
