// Generated by dts-bundle-generator v8.0.1

export type Node = DocumentNode | ElementNode | TextNode | CommentNode | DoctypeNode;
export type NodeType = typeof DOCUMENT_NODE | typeof ELEMENT_NODE | typeof TEXT_NODE | typeof COMMENT_NODE | typeof DOCTYPE_NODE;
export interface Location {
	start: number;
	end: number;
}
interface BaseNode {
	type: NodeType;
	loc: [
		Location,
		Location
	];
	parent: Node;
	[key: string]: any;
}
interface LiteralNode extends BaseNode {
	value: string;
}
interface ParentNode extends BaseNode {
	children: Node[];
}
export interface DocumentNode extends Omit<ParentNode, "parent"> {
	type: typeof DOCUMENT_NODE;
	attributes: Record<string, string>;
	parent: undefined;
}
export interface ElementNode extends ParentNode {
	type: typeof ELEMENT_NODE;
	name: string;
	attributes: Record<string, string>;
}
export interface TextNode extends LiteralNode {
	type: typeof TEXT_NODE;
}
export interface CommentNode extends LiteralNode {
	type: typeof COMMENT_NODE;
}
export interface DoctypeNode extends LiteralNode {
	type: typeof DOCTYPE_NODE;
}
export declare const DOCUMENT_NODE = 0;
export declare const ELEMENT_NODE = 1;
export declare const TEXT_NODE = 2;
export declare const COMMENT_NODE = 3;
export declare const DOCTYPE_NODE = 4;
export declare function h(type: any, props?: null | Record<string, any>, ...children: any[]): ElementNode;
export declare const Fragment: unique symbol;
export declare function parse(input: string | ReturnType<typeof html>): any;
export interface Visitor {
	(node: Node, parent?: Node, index?: number): void | Promise<void>;
}
export interface VisitorSync {
	(node: Node, parent?: Node, index?: number): void;
}
export declare const RenderFn: unique symbol;
declare function __unsafeHTML(str: string): {
	value: string;
};
declare function __unsafeRenderFn(node: ElementNode, fn: (props: Record<string, any>, ...children: Node[]) => Node): ElementNode;
export declare function attrs(attributes: Record<string, string>): {
	value: string;
};
export declare function html(tmpl: TemplateStringsArray, ...vals: any[]): {
	value: string;
};
export declare function walk(node: Node, callback: Visitor): Promise<void>;
export declare function walkSync(node: Node, callback: VisitorSync): void;
export declare function renderSync(node: Node): string;
export declare function render(node: Node): Promise<string>;
export interface Transformer {
	(node: Node): Node | Promise<Node>;
}
export declare function transform(markup: string | Node, transformers?: Transformer[]): Promise<string>;

export {};
