import * as _nuxt_schema from '@nuxt/schema';
import { HookResult } from '@nuxt/schema';
import * as vuetify_locale from 'vuetify/locale';
import * as vuetify_labs_components from 'vuetify/labs/components';
import * as vuetify_directives from 'vuetify/directives';
import * as vuetify_components from 'vuetify/components';
import { VuetifyOptions, createVuetify, LocaleOptions, RtlOptions } from 'vuetify';

type DateAdapter = 'vuetify' | 'date-fns' | 'moment' | 'luxon' | 'dayjs' | 'js-joda' | 'date-fns-jalali' | 'jalaali' | 'hijri' | 'custom';
/**
 * Date configuration.
 */
interface DateOptions {
    /**
     * The date adapter.
     *
     * The adapter will be picked from the dependencies.
     * When multiple `@date-io/xxxx` libraries installed in your project,
     * you should specify the adapter otherwise an error will be thrown.
     *
     * If you want to use a custom adapter, configure `adapter: 'custom'`,
     * and then add a Nuxt plugin to configure the adapter using `vuetify:configuration` hook.
     *
     * @default 'vuetify'
     */
    adapter?: DateAdapter;
    /**
     * Formats.
     */
    formats?: Record<string, string>;
    /**
     * Locales.
     *
     * When `@nuxtjs/i18n` Nuxt module is present, this option will be ignored, locales will be extracted from the available locales.
     */
    locale?: Record<string, any>;
}
type IconSetName = 'mdi' | 'fa' | 'fa4' | 'md' | 'mdi-svg' | 'fa-svg' | 'unocss-mdi' | 'custom';
type IconFontName = 'unocss-mdi' | 'mdi' | 'fa' | 'fa4' | 'md';
interface JSSVGIconSet {
    aliases?: Record<string, string>;
}
interface FontAwesomeSvgIconSet {
    /**
     * The libraries to import and register with the corresponding name.
     *
     * For example, to import free svg icons, `libraries` should be (the default):
     * `libraries: [[false, 'fas', '@fortawesome/free-solid-svg-icons']]
     *
     * Following with the example, the resulting import will be:
     * `import { fas } from '@fortawesome/free-solid-svg-icons'`
     *
     * @default [[false, 'fas', '@fortawesome/free-solid-svg-icons']]
     */
    libraries?: [defaultExport: boolean, name: string, library: string][];
}
interface FontIconSet {
    name: IconFontName;
    /**
     * Use CDN?
     *
     * - mdi: https://cdn.jsdelivr.net/npm/@mdi/font@latest/css/materialdesignicons
     * - md:  https://fonts.googleapis.com/css?family=Material+Icons
     * - fa:  https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@latest/css/all.min.css
     * - fa4: https://cdn.jsdelivr.net/npm/font-awesome@4.x/css/font-awesome.min.css
     *
     * @default the corresponding CDN for the icon set
     */
    cdn?: string;
}
interface UnoCCSMdiIconSet {
    collapse?: string;
    complete?: string;
    cancel?: string;
    close?: string;
    delete?: string;
    clear?: string;
    success?: string;
    info?: string;
    warning?: string;
    error?: string;
    prev?: string;
    next?: string;
    checkboxOn?: string;
    checkboxOff?: string;
    checkboxIndeterminate?: string;
    delimiter?: string;
    sortAsc?: string;
    sortDesc?: string;
    expand?: string;
    menu?: string;
    subgroup?: string;
    dropdown?: string;
    radioOn?: string;
    radioOff?: string;
    edit?: string;
    ratingEmpty?: string;
    ratingFull?: string;
    ratingHalf?: string;
    loading?: string;
    first?: string;
    last?: string;
    unfold?: string;
    file?: string;
    plus?: string;
    minus?: string;
    calendar?: string;
}
interface IconsOptions {
    /**
     * @default 'mdi'
     */
    defaultSet: IconSetName;
    /**
     * The prefix for UnoCSS Preset Icons.
     *
     * @default 'i-'
     */
    unocssIconPrefix?: string;
    /**
     * Override the default mdi icons.
     *
     * Icon names should include the prefix and the collection, for example:
     * - home: i-<collection>:<icon>
     */
    unocssIcons?: UnoCCSMdiIconSet;
    unocssAdditionalIcons?: Record<string, string>;
    sets?: IconFontName | IconFontName[] | FontIconSet[];
    svg?: {
        mdi?: JSSVGIconSet;
        fa?: FontAwesomeSvgIconSet;
    };
}
type ComponentName = keyof typeof vuetify_components;
type Components = false | ComponentName | ComponentName[];
type DirectiveName = keyof typeof vuetify_directives;
type Directives = boolean | DirectiveName | DirectiveName[];
type LabComponentName = keyof typeof vuetify_labs_components;
type LabComponents = boolean | LabComponentName | LabComponentName[];
type VuetifyLocale = keyof typeof vuetify_locale;
interface VOptions extends Partial<Omit<VuetifyOptions, 'ssr' | 'aliases' | 'components' | 'directives' | 'locale' | 'date' | 'icons'>> {
    /**
     * Configure the SSR options.
     *
     * This option is only used when SSR is enabled in your Nuxt configuration.
     */
    ssr?: {
        clientWidth: number;
        clientHeight?: number;
    };
    aliases?: Record<string, ComponentName>;
    /**
     * Do you need to configure some global components?.
     *
     * @default false
     */
    components?: Components;
    /**
     * Configure the locale messages, the locale, the fallback locale and RTL options.
     *
     * When `@nuxtjs/i18n` Nuxt module is present, the following options will be ignored:
     * - `locale`
     * - `fallback`
     * - `rtl`
     * - `messages`
     *
     * The adapter will be `vuetify`, if you want to use another adapter, check `date` option.
     */
    locale?: Omit<LocaleOptions, 'adapter'> & RtlOptions;
    /**
     * Include locale messages?
     *
     * When `@nuxtjs/i18n` Nuxt module is present, this option will be ignored.
     *
     * You can include the locales you want to use in your application, this module will load and configure the messages for you.
     */
    localeMessages?: VuetifyLocale | VuetifyLocale[];
    /**
     * Include the lab components?
     *
     * You can include all lab components configuring `labComponents: true`.
     *
     * You can provide an array with the names of the lab components to include.
     *
     * @see https://vuetifyjs.com/en/labs/introduction/
     *
     * @default false
     */
    labComponents?: LabComponents;
    /**
     * Include the directives?
     *
     * You can include all directives configuring `directives: true`.
     *
     * You can provide an array with the names of the directives to include.
     *
     * @default false
     */
    directives?: Directives;
    /**
     * Date configuration.
     *
     * When this option is configured, the `v-date-picker` lab component will be included.
     *
     * @see https://vuetifyjs.com/features/dates/
     * @see https://vuetifyjs.com/components/date-pickers/
     */
    date?: DateOptions;
    /**
     * Include the icons?
     *
     * By default, `mdi` icons will be used via cdn: https://cdn.jsdelivr.net/npm/@mdi/font@latest/css/materialdesignicons.min.css.
     *
     * @see https://vuetifyjs.com/en/features/icon-fonts/
     */
    icons?: false | IconsOptions;
}
interface MOptions {
    /**
     * @default true
     */
    importComposables?: boolean;
    /**
     * If you are using another composables that collide with the Vuetify ones,
     * enable this flag to prefix them with `V`:
     * - `useLocale` -> `useVLocale`
     * - `useDefaults` -> `useVDefaults`
     * - `useDisplay` -> `useVDisplay`
     * - `useLayout` -> `useVLayout`
     * - `useRtl` -> `useVRtl`
     * - `useTheme` -> `useVTheme`
     *
     * @default false
     */
    prefixComposables?: boolean;
    /**
     * Vuetify styles.
     *
     * If you want to use configFile on SSR, you have to disable `experimental.inlineSSRStyles` in nuxt.config.
     *
     * @see https://github.com/vuetifyjs/vuetify-loader/tree/master/packages/vite-plugin
     * @see https://github.com/userquin/vuetify-nuxt-module/issues/78 and https://github.com/userquin/vuetify-nuxt-module/issues/74
     */
    styles?: true | 'none' | 'expose' | 'sass' | {
        configFile: string;
    };
    /**
     * Add Vuetify Vite Plugin `transformAssetsUrls`?
     *
     * @default true
     */
    includeTransformAssetsUrls?: boolean | Record<string, string[]>;
    /**
     * Vuetify SSR client hints.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Client_hints
     */
    ssrClientHints?: {
        /**
         * Should the module reload the page on first request?
         *
         * @default false
         */
        reloadOnFirstRequest?: boolean;
        /**
         * Enable `Sec-CH-Viewport-Width` and `Sec-CH-Viewport-Height` headers?
         *
         * @see https://wicg.github.io/responsive-image-client-hints/#sec-ch-viewport-width
         * @see https://wicg.github.io/responsive-image-client-hints/#sec-ch-viewport-height
         *
         * @default false
         */
        viewportSize?: boolean;
        /**
         * Enable `Sec-CH-Prefers-Color-Scheme` header?
         *
         * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-Prefers-Color-Scheme
         *
         * @default false
         */
        prefersColorScheme?: boolean;
        /**
         * The options for `prefersColorScheme`, `prefersColorScheme` must be enabled.
         *
         * If you want the module to handle the color scheme for you, you should configure this option, otherwise you'll need to add your custom implementation.
         */
        prefersColorSchemeOptions?: {
            /**
             * The name for the cookie.
             *
             * @default 'color-scheme'
             */
            cookieName?: string;
            /**
             * The name for the dark theme.
             *
             * @default 'dark'
             */
            darkThemeName?: string;
            /**
             * The name for the light theme.
             *
             * @default 'light'
             */
            lightThemeName?: string;
            /**
             * Use the browser theme only?
             *
             * This flag can be used when your application provides a custom dark and light themes,
             * but will not provide a theme switcher, that's, using by default the browser theme.
             *
             * @default false
             */
            useBrowserThemeOnly?: boolean;
        };
        /**
         * Enable `Sec-CH-Prefers-Reduced-Motion` header?
         *
         * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Sec-CH-Prefers-Reduced-Motion
         *
         * @default false
         */
        prefersReducedMotion?: boolean;
    };
}
interface ModuleOptions {
    moduleOptions?: MOptions;
    /**
     * Vuetify options.
     *
     * You can inline the configuration or specify a file path:
     * `vuetifyOptions: './vuetify.options.ts'`
     *
     * The path should be relative to the root folder.
     */
    vuetifyOptions?: string | VOptions;
}
interface InlineModuleOptions extends Omit<ModuleOptions, 'vuetifyOptions'> {
    vuetifyOptions: VOptions;
}
interface ExternalVuetifyOptions extends VOptions {
    config?: boolean;
}
/**
 * Request headers received from the client in SSR.
 */
interface SSRClientHints {
    /**
     * Is the first request the browser hits the server?
     */
    firstRequest: boolean;
    /**
     * The browser supports prefer-color-scheme client hints?
     */
    prefersColorSchemeAvailable: boolean;
    /**
     * The browser supports prefer-reduced-motion client hints?
     */
    prefersReducedMotionAvailable: boolean;
    /**
     * The browser supports viewport-height client hints?
     */
    viewportHeightAvailable: boolean;
    /**
     * The browser supports viewport-width client hints?
     */
    viewportWidthAvailable: boolean;
    prefersColorScheme?: 'dark' | 'light' | 'no-preference';
    prefersReducedMotion?: 'no-preference' | 'reduce';
    viewportHeight?: number;
    viewportWidth?: number;
    /**
     * The theme name from the cookie.
     */
    colorSchemeFromCookie?: string;
    colorSchemeCookie?: string;
}
interface SSRClientHintsConfiguration {
    enabled: boolean;
    viewportSize: boolean;
    prefersColorScheme: boolean;
    prefersReducedMotion: boolean;
    prefersColorSchemeOptions?: {
        baseUrl: string;
        defaultTheme: string;
        themeNames: string[];
        cookieName: string;
        darkThemeName: string;
        lightThemeName: string;
    };
}
interface ModuleHooks {
    'vuetify:registerModule': (registerModule: (config: InlineModuleOptions) => void) => HookResult;
}
declare module '#app/nuxt' {
    interface RuntimeNuxtHooks {
        'vuetify:configuration': (options: {
            isDev: boolean;
            vuetifyOptions: VuetifyOptions;
        }) => HookResult;
        'vuetify:before-create': (options: {
            isDev: boolean;
            vuetifyOptions: VuetifyOptions;
        }) => HookResult;
        'vuetify:ready': (vuetify: ReturnType<typeof createVuetify>) => HookResult;
        'vuetify:ssr-client-hints': (options: {
            vuetifyOptions: VuetifyOptions;
            ssrClientHints: SSRClientHints;
            ssrClientHintsConfiguration: SSRClientHintsConfiguration;
        }) => HookResult;
    }
}
declare module '@nuxt/schema' {
    interface NuxtConfig {
        ['vuetify']?: Partial<ModuleOptions>;
    }
    interface NuxtOptions {
        ['vuetify']?: ModuleOptions;
    }
    interface NuxtHooks extends ModuleHooks {
    }
}

declare const _default: _nuxt_schema.NuxtModule<ModuleOptions>;

export { ComponentName, Components, DateAdapter, DateOptions, DirectiveName, Directives, ExternalVuetifyOptions, FontAwesomeSvgIconSet, FontIconSet, IconFontName, IconSetName, IconsOptions, InlineModuleOptions, JSSVGIconSet, LabComponentName, LabComponents, MOptions, ModuleHooks, ModuleOptions, SSRClientHints, SSRClientHintsConfiguration, UnoCCSMdiIconSet, VOptions, VuetifyLocale, _default as default };
