import * as vue from 'vue';
import { ComponentPropsOptions, ExtractPropTypes, VNodeChild, VNode, JSXComponent, PropType, ComponentInternalInstance, Ref, ComputedRef, InjectionKey, UnwrapRef } from 'vue';

type SlotsToProps<U extends RawSlots, T = MakeInternalSlots<U>> = {
    $children?: (VNodeChild | (T extends {
        default: infer V;
    } ? V : {}) | {
        [K in keyof T]?: T[K];
    });
    'v-slots'?: {
        [K in keyof T]?: T[K] | false;
    };
} & {
    [K in keyof T as `v-slot:${K & string}`]?: T[K] | false;
};
type RawSlots = Record<string, unknown>;
type Slot<T> = [T] extends [never] ? () => VNodeChild : (arg: T) => VNodeChild;
type VueSlot<T> = [T] extends [never] ? () => VNode[] : (arg: T) => VNode[];
type MakeInternalSlots<T extends RawSlots> = {
    [K in keyof T]: Slot<T[K]>;
};
type MakeSlots<T extends RawSlots> = {
    [K in keyof T]: VueSlot<T[K]>;
};
type GenericProps<Props, Slots extends Record<string, unknown>> = {
    $props: Props & SlotsToProps<Slots>;
    $slots: MakeSlots<Slots>;
};
interface FilterPropsOptions<PropsOptions extends Readonly<ComponentPropsOptions>, Props = ExtractPropTypes<PropsOptions>> {
    filterProps<T extends Partial<Props>, U extends Exclude<keyof Props, Exclude<keyof Props, keyof T>>>(props: T): Partial<Pick<T, U>>;
}

declare const breakpoints: readonly ["sm", "md", "lg", "xl", "xxl"];
type Breakpoint = typeof breakpoints[number];
type DisplayBreakpoint = 'xs' | Breakpoint;

type IconValue = string | (string | [path: string, opacity: number])[] | JSXComponent;
declare const IconValue: PropType<IconValue>;

interface GroupItem {
    id: number;
    value: Ref<unknown>;
    disabled: Ref<boolean | undefined>;
}
interface GroupProvide {
    register: (item: GroupItem, cmp: ComponentInternalInstance) => void;
    unregister: (id: number) => void;
    select: (id: number, value: boolean) => void;
    selected: Ref<Readonly<number[]>>;
    isSelected: (id: number) => boolean;
    prev: () => void;
    next: () => void;
    selectedClass: Ref<string | undefined>;
    items: ComputedRef<{
        id: number;
        value: unknown;
        disabled: boolean | undefined;
    }[]>;
    disabled: Ref<boolean | undefined>;
    getItemIndex: (value: unknown) => number;
}
interface GroupItemProvide {
    id: number;
    isSelected: Ref<boolean>;
    toggle: () => void;
    select: (value: boolean) => void;
    selectedClass: Ref<(string | undefined)[] | false>;
    value: Ref<unknown>;
    disabled: Ref<boolean | undefined>;
    group: GroupProvide;
}

interface SlideGroupSlot {
    next: GroupProvide['next'];
    prev: GroupProvide['prev'];
    select: GroupProvide['select'];
    isSelected: GroupProvide['isSelected'];
}
type VSlideGroupSlots = {
    default: SlideGroupSlot;
    prev: SlideGroupSlot;
    next: SlideGroupSlot;
};
declare const VSlideGroup: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: Partial<{
            symbol: any;
            direction: "horizontal" | "vertical";
            style: vue.StyleValue;
            disabled: boolean;
            multiple: boolean;
            tag: string;
            selectedClass: string;
            nextIcon: IconValue;
            prevIcon: IconValue;
            centerActive: boolean;
        }> & Omit<{
            symbol: any;
            direction: "horizontal" | "vertical";
            style: vue.StyleValue;
            disabled: boolean;
            multiple: boolean;
            tag: string;
            selectedClass: string;
            nextIcon: IconValue;
            prevIcon: IconValue;
            centerActive: boolean;
            max?: number | undefined;
            class?: any;
            mandatory?: boolean | "force" | undefined;
            mobileBreakpoint?: number | DisplayBreakpoint | undefined;
            showArrows?: string | boolean | undefined;
        } & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
            symbol: any;
            direction: "horizontal" | "vertical";
            style: vue.StyleValue;
            disabled: boolean;
            multiple: boolean;
            tag: string;
            selectedClass: string;
            nextIcon: IconValue;
            prevIcon: IconValue;
            centerActive: boolean;
        } & {
            max?: number | undefined;
            class?: any;
            mandatory?: boolean | "force" | undefined;
            mobileBreakpoint?: number | DisplayBreakpoint | undefined;
            showArrows?: string | boolean | undefined;
        } & {}, "symbol" | "direction" | "style" | "disabled" | "multiple" | "tag" | "selectedClass" | "nextIcon" | "prevIcon" | "centerActive">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            default?: ((arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            prev?: ((arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
            next?: ((arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: (event: string, ...args: any[]) => void;
        $el: any;
        $options: vue.ComponentOptionsBase<{
            symbol: any;
            direction: "horizontal" | "vertical";
            style: vue.StyleValue;
            disabled: boolean;
            multiple: boolean;
            tag: string;
            selectedClass: string;
            nextIcon: IconValue;
            prevIcon: IconValue;
            centerActive: boolean;
        } & {
            max?: number | undefined;
            class?: any;
            mandatory?: boolean | "force" | undefined;
            mobileBreakpoint?: number | DisplayBreakpoint | undefined;
            showArrows?: string | boolean | undefined;
        } & {}, {
            selected: vue.Ref<readonly number[]>;
            scrollTo: (location: 'prev' | 'next') => void;
            scrollOffset: vue.ShallowRef<number>;
            focus: (location?: 'next' | 'prev' | 'first' | 'last') => void;
        }, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Omit<{
            'update:modelValue': (value: any) => boolean;
        }, "$children" | "v-slot:default" | "v-slots" | "modelValue" | "update:modelValue" | "v-slot:next" | "v-slot:prev">, string, {
            symbol: any;
            direction: "horizontal" | "vertical";
            style: vue.StyleValue;
            disabled: boolean;
            multiple: boolean;
            tag: string;
            selectedClass: string;
            nextIcon: IconValue;
            prevIcon: IconValue;
            centerActive: boolean;
        }, {}, string, vue.SlotsType<Partial<{
            default: (arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            prev: (arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
            next: (arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {
        symbol: any;
        direction: "horizontal" | "vertical";
        style: vue.StyleValue;
        disabled: boolean;
        multiple: boolean;
        tag: string;
        selectedClass: string;
        nextIcon: IconValue;
        prevIcon: IconValue;
        centerActive: boolean;
    } & {
        max?: number | undefined;
        class?: any;
        mandatory?: boolean | "force" | undefined;
        mobileBreakpoint?: number | DisplayBreakpoint | undefined;
        showArrows?: string | boolean | undefined;
    } & {} & vue.ShallowUnwrapRef<{
        selected: vue.Ref<readonly number[]>;
        scrollTo: (location: 'prev' | 'next') => void;
        scrollOffset: vue.ShallowRef<number>;
        focus: (location?: 'next' | 'prev' | 'first' | 'last') => void;
    }> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    symbol: any;
    direction: "horizontal" | "vertical";
    style: vue.StyleValue;
    disabled: boolean;
    multiple: boolean;
    tag: string;
    selectedClass: string;
    nextIcon: IconValue;
    prevIcon: IconValue;
    centerActive: boolean;
} & {
    max?: number | undefined;
    class?: any;
    mandatory?: boolean | "force" | undefined;
    mobileBreakpoint?: number | DisplayBreakpoint | undefined;
    showArrows?: string | boolean | undefined;
} & {}, {
    selected: vue.Ref<readonly number[]>;
    scrollTo: (location: 'prev' | 'next') => void;
    scrollOffset: vue.ShallowRef<number>;
    focus: (location?: 'next' | 'prev' | 'first' | 'last') => void;
}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, Omit<{
    'update:modelValue': (value: any) => boolean;
}, "$children" | "v-slot:default" | "v-slots" | "modelValue" | "update:modelValue" | "v-slot:next" | "v-slot:prev">, string, {
    symbol: any;
    direction: "horizontal" | "vertical";
    style: vue.StyleValue;
    disabled: boolean;
    multiple: boolean;
    tag: string;
    selectedClass: string;
    nextIcon: IconValue;
    prevIcon: IconValue;
    centerActive: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: (arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    prev: (arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
    next: (arg: SlideGroupSlot) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & (new <T_1>(props: {
    modelValue?: T_1 | undefined;
    'onUpdate:modelValue'?: ((value: T_1) => void) | undefined;
}, slots: VSlideGroupSlots) => GenericProps<{
    modelValue?: T_1 | undefined;
    'onUpdate:modelValue'?: ((value: T_1) => void) | undefined;
}, VSlideGroupSlots>) & FilterPropsOptions<{
    modelValue: {
        type: null;
        default: undefined;
    };
    multiple: BooleanConstructor;
    mandatory: PropType<boolean | "force">;
    max: NumberConstructor;
    selectedClass: {
        type: PropType<string>;
        default: string;
    };
    disabled: BooleanConstructor;
    tag: {
        type: StringConstructor;
        default: string;
    };
    mobileBreakpoint: PropType<number | DisplayBreakpoint>;
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    centerActive: BooleanConstructor;
    direction: {
        type: PropType<"horizontal" | "vertical">;
        default: string;
    };
    symbol: {
        type: null;
        default: InjectionKey<GroupProvide>;
    };
    nextIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    prevIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    showArrows: {
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
}, vue.ExtractPropTypes<{
    modelValue: {
        type: null;
        default: undefined;
    };
    multiple: BooleanConstructor;
    mandatory: PropType<boolean | "force">;
    max: NumberConstructor;
    selectedClass: {
        type: PropType<string>;
        default: string;
    };
    disabled: BooleanConstructor;
    tag: {
        type: StringConstructor;
        default: string;
    };
    mobileBreakpoint: PropType<number | DisplayBreakpoint>;
    class: PropType<any>;
    style: {
        type: PropType<vue.StyleValue>;
        default: null;
    };
    centerActive: BooleanConstructor;
    direction: {
        type: PropType<"horizontal" | "vertical">;
        default: string;
    };
    symbol: {
        type: null;
        default: InjectionKey<GroupProvide>;
    };
    nextIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    prevIcon: {
        type: PropType<IconValue>;
        default: string;
    };
    showArrows: {
        type: (StringConstructor | BooleanConstructor)[];
        validator: (v: any) => boolean;
    };
}>>;
type VSlideGroup = InstanceType<typeof VSlideGroup>;

declare const VSlideGroupItem: {
    new (...args: any[]): {
        $: vue.ComponentInternalInstance;
        $data: {};
        $props: Partial<{
            disabled: boolean;
        }> & Omit<{
            disabled: boolean;
            value?: any;
            selectedClass?: string | undefined;
            $children?: vue.VNodeChild | {
                default?: ((arg: {
                    isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                    select: GroupItemProvide['select'];
                    toggle: GroupItemProvide['toggle'];
                    selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
                }) => vue.VNodeChild) | undefined;
            } | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild);
            'v-slots'?: {
                default?: false | ((arg: {
                    isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                    select: GroupItemProvide['select'];
                    toggle: GroupItemProvide['toggle'];
                    selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
                }) => vue.VNodeChild) | undefined;
            } | undefined;
            "v-slot:default"?: false | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild) | undefined;
            "onGroup:selected"?: ((val: {
                value: boolean;
            }) => any) | undefined;
        } & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & {
            disabled: boolean;
        } & {
            value?: any;
            selectedClass?: string | undefined;
        } & {
            $children?: vue.VNodeChild | {
                default?: ((arg: {
                    isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                    select: GroupItemProvide['select'];
                    toggle: GroupItemProvide['toggle'];
                    selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
                }) => vue.VNodeChild) | undefined;
            } | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild);
            'v-slots'?: {
                default?: false | ((arg: {
                    isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                    select: GroupItemProvide['select'];
                    toggle: GroupItemProvide['toggle'];
                    selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
                }) => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild) | undefined;
        } & {
            "onGroup:selected"?: ((val: {
                value: boolean;
            }) => any) | undefined;
        }, "disabled">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            default?: ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[]) | undefined;
        }>;
        $root: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $parent: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null;
        $emit: (event: "group:selected", val: {
            value: boolean;
        }) => void;
        $el: any;
        $options: vue.ComponentOptionsBase<{
            disabled: boolean;
        } & {
            value?: any;
            selectedClass?: string | undefined;
        } & {
            $children?: vue.VNodeChild | {
                default?: ((arg: {
                    isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                    select: GroupItemProvide['select'];
                    toggle: GroupItemProvide['toggle'];
                    selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
                }) => vue.VNodeChild) | undefined;
            } | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild);
            'v-slots'?: {
                default?: false | ((arg: {
                    isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                    select: GroupItemProvide['select'];
                    toggle: GroupItemProvide['toggle'];
                    selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
                }) => vue.VNodeChild) | undefined;
            } | undefined;
        } & {
            "v-slot:default"?: false | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild) | undefined;
        } & {
            "onGroup:selected"?: ((val: {
                value: boolean;
            }) => any) | undefined;
        }, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
            [key: string]: any;
        }>[] | undefined, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
            'group:selected': (val: {
                value: boolean;
            }) => true;
        }, string, {
            disabled: boolean;
        }, {}, string, vue.SlotsType<Partial<{
            default: (arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNode<vue.RendererNode, vue.RendererElement, {
                [key: string]: any;
            }>[];
        }>>> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: vue.DebuggerEvent) => void) | ((e: vue.DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: vue.ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, vue.ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string, {}>, {}, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof vue.nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: vue.WatchOptions<boolean> | undefined): vue.WatchStopHandle;
    } & {
        disabled: boolean;
    } & {
        value?: any;
        selectedClass?: string | undefined;
    } & {
        $children?: vue.VNodeChild | {
            default?: ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild) | undefined;
        } | ((arg: {
            isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
            select: GroupItemProvide['select'];
            toggle: GroupItemProvide['toggle'];
            selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
        }) => vue.VNodeChild);
        'v-slots'?: {
            default?: false | ((arg: {
                isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
                select: GroupItemProvide['select'];
                toggle: GroupItemProvide['toggle'];
                selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
            }) => vue.VNodeChild) | undefined;
        } | undefined;
    } & {
        "v-slot:default"?: false | ((arg: {
            isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
            select: GroupItemProvide['select'];
            toggle: GroupItemProvide['toggle'];
            selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
        }) => vue.VNodeChild) | undefined;
    } & {
        "onGroup:selected"?: ((val: {
            value: boolean;
        }) => any) | undefined;
    } & vue.ShallowUnwrapRef<() => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[] | undefined> & {} & vue.ComponentCustomProperties & {};
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & vue.ComponentOptionsBase<{
    disabled: boolean;
} & {
    value?: any;
    selectedClass?: string | undefined;
} & {
    $children?: vue.VNodeChild | {
        default?: ((arg: {
            isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
            select: GroupItemProvide['select'];
            toggle: GroupItemProvide['toggle'];
            selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
        }) => vue.VNodeChild) | undefined;
    } | ((arg: {
        isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
        select: GroupItemProvide['select'];
        toggle: GroupItemProvide['toggle'];
        selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
    }) => vue.VNodeChild);
    'v-slots'?: {
        default?: false | ((arg: {
            isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
            select: GroupItemProvide['select'];
            toggle: GroupItemProvide['toggle'];
            selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
        }) => vue.VNodeChild) | undefined;
    } | undefined;
} & {
    "v-slot:default"?: false | ((arg: {
        isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
        select: GroupItemProvide['select'];
        toggle: GroupItemProvide['toggle'];
        selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
    }) => vue.VNodeChild) | undefined;
} & {
    "onGroup:selected"?: ((val: {
        value: boolean;
    }) => any) | undefined;
}, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>[] | undefined, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {
    'group:selected': (val: {
        value: boolean;
    }) => true;
}, string, {
    disabled: boolean;
}, {}, string, vue.SlotsType<Partial<{
    default: (arg: {
        isSelected: UnwrapRef<GroupItemProvide['isSelected']>;
        select: GroupItemProvide['select'];
        toggle: GroupItemProvide['toggle'];
        selectedClass: UnwrapRef<GroupItemProvide['selectedClass']>;
    }) => vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }>[];
}>>> & vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps & FilterPropsOptions<{
    value: null;
    disabled: BooleanConstructor;
    selectedClass: StringConstructor;
}, vue.ExtractPropTypes<{
    value: null;
    disabled: BooleanConstructor;
    selectedClass: StringConstructor;
}>>;
type VSlideGroupItem = InstanceType<typeof VSlideGroupItem>;

export { VSlideGroup, VSlideGroupItem };
